% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivrecNP.R
\name{bivrecNP}
\alias{bivrecNP}
\title{Nonparametric Analysis of Bivariate Alternating Recurrent Event Gap Time Data}
\usage{
bivrecNP(response, ai, u1, u2, level, conditional, given.interval)
}
\arguments{
\item{response}{A response object of class \verb{bivrecSurv}.}

\item{ai}{See details.}

\item{u1}{A vector or single number to be used for the estimation of joint cdf P(Type I gap times \eqn{\le} u1, Type II gap times \eqn{\le} u2) in the nonparametric method.}

\item{u2}{A vector or single number to be used for the estimation of joint cdf P(Type I gap times \eqn{\le} u1, Type II gap times \eqn{\le} u2) in the nonparametric method.}

\item{level}{The confidence level for confidence intervals for joint cdf, marginal survival probability and conditional cdf. Must be between 0.50 and 0.99. Default is 0.95.}

\item{conditional}{A logical value. If TRUE, this function will calculate the conditional cdf for the Type II gap time given an interval of the Type I gap time and the bootstrap standard error and confidence interval at the specified confidence level. Default is FALSE.}

\item{given.interval}{A vector c(v1, v2) that must be specified if conditional = TRUE. The vector indicates an interval for the Type I gap time to use for the estimation of the cdf of the Type II gap time given this interval.
If given.interval = c(v1, v2), the function calculates P(Type II gap times \eqn{\le} y | v1 \eqn{\le} Type I gap times \eqn{\le} v2). The given values v1 and v2 must be in the range of gap times in the estimated marginal survival.}
}
\value{
A bivrecNP object that contains:
\itemize{
  \item \verb{joint_cdf}
  \item \verb{marginal_survival}
  \item \verb{conditional_cdf} (when conditional = TRUE)
  \item \verb{formula}
  \item \verb{ai}
  \item \verb{level}
  \item \verb{given.interval} (when conditional = TRUE)
  \item \verb{xij, yij}
  \item \verb{new_data}
}
}
\description{
This function allows users to estimate the joint cumulative distribution function (cdf) for the two types of gap times (xij, yij), the marginal survival function for the Type I gap times (xij), and the conditional cdf for the Type II gap times (yij) given the Type I gap times (xij). See details for the estimation methods provided.
}
\details{
\verb{ai} indicates a real non-negative function of censoring times to be used as weights in the nonparametric method. This variable can take on values of 1 or 2 which indicate:
\itemize{
\item \verb{ai=1} (default): the weights are simply 1 for all subjects, \eqn{a(Ci) = 1}.
\item \verb{ai=2}: the weight for each subject is the subject's censoring time, \eqn{a(Ci) = Ci}.
}

Related methods: \verb{plot.bivrecNP}, \verb{head.bivrecNP}, \verb{print.bivrecNP}.
}
\examples{

\dontrun{

library(BivRec)

# Simulate bivariate alternating recurrent event data
set.seed(28)
sim_data <- simBivRec(nsize=100, beta1=c(0.5,0.5), beta2=c(0,-0.5),
            tau_c=63, set=1.1)
bivrecsurv_data <- with(sim_data, bivrecSurv(id, epi, xij, yij, d1, d2))
npresult <- bivrecNP(response = bivrecsurv_data, ai=1,
                     u1 = seq(2, 20, 1), u2 = seq(1, 15, 1), level=0.99)
head(npresult)
plot(npresult)

#This is an example with longer runtime

 npresult2 <- bivrecNP(response = bivrecsurv_data, ai=1,
               u1 = seq(2, 20, 1), u2 = seq(1, 15, 1), conditional = TRUE,
               given.interval = c(0, 10), level = 0.99)
 head(npresult2)
 plot(npresult2)
}

}
\references{
Huang CY, Wang MC. (2005). Nonparametric estimation of the bivariate recurrence time distribution. Biometrics, 61: 392-402.
\url{https://onlinelibrary.wiley.com/doi/abs/10.1111/j.1541-0420.2005.00328.x}
}
