% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biv.rec.reformat.R
\name{biv.rec.reformat}
\alias{biv.rec.reformat}
\title{A function to create a biv.rec object}
\usage{
biv.rec.reformat(identifier, xij, yij, c_indicatorY, c_indicatorX, episode,
  covariates, method, ai, condgx, data)
}
\arguments{
\item{identifier}{Vector of subject's unique identifier (i). Passed from biv.rec.fit()}

\item{xij}{Vector with the lengths of time spent in event of type X for individual i in episode j. Passed from biv.rec.fit()}

\item{yij}{vector with the lengths of time spent in event of type Y for individual i in episode j. Passed from biv.rec.fit()}

\item{c_indicatorY}{Vector with values of 0 for the last episode for subject i or 1 otherwise. A subject with only one episode will have one 0. Passed from biv.rec.fit()}

\item{c_indicatorX}{Optional vector with values of 0 if the last episode for subject i occurred for event of type X or 1 otherwise. A subject with only one episode could have either one 1 (if he was censored at event Y) or one 0 (if he was censored at event X). Passed from biv.rec.fit()}

\item{episode}{Vector indicating the observation or episode (j) for a subject (i). Passed from biv.rec.fit()}

\item{covariates}{A Matrix of Covariates. Passed from biv.rec.fit()}

\item{method}{A string for method to be used. Passed from biv.rec.fit()}

\item{ai}{Passed from biv.rec.fit()}

\item{condgx}{Passed from biv.rec.fit()}

\item{data}{Passed from biv.rec.fit()}
}
\value{
a biv.rec object ready for fitting.
}
\description{
This function simulates recurrent event data based on a linear combination of two covariates.
}
\seealso{
\code{\link{biv.rec.fit}}
}
\keyword{internal}
