% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/428-extractDrugIPMolecularLearning.R
\name{extrDrugIPMolecularLearning}
\alias{extrDrugIPMolecularLearning}
\title{Calculates the Descriptor that Evaluates the Ionization Potential}
\usage{
extrDrugIPMolecularLearning(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules, 
each column represents one feature. 
This function returns one column named \code{MolIP}.
}
\description{
Calculates the Descriptor that Evaluates the Ionization Potential
}
\details{
Calculate the ionization potential of a molecule. 
The descriptor assumes that explicit hydrogens have been added to the molecules.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugIPMolecularLearning(mol)
head(dat)

}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Ionization}
\keyword{Potential}
\keyword{extrDrugIPMolecularLearning}
