% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/609-extractDNAPseDNC.R
\name{extrDNAPseDNC}
\alias{extrDNAPseDNC}
\title{The Pseudo Dinucleotide Composition Descriptor}
\usage{
extrDNAPseDNC(x, lambda = 3, w = 0.05, normalize = FALSE,
  customprops = NULL)
}
\arguments{
\item{x}{the input data, which should be a list or file type.}

\item{lambda}{an integer larger than or equal to 0 and less than or equal to L-2 (L means the length of the shortest 
sequence in the dataset). It represents the highest counted rank (or tier) of the correlation along a 
DNA sequence. Its default value is 3.}

\item{w}{the weight factor ranged from 0 to 1. Its default value is 0.05.}

\item{normalize}{with this option, the final feature vector will be normalized based
on the total occurrences of all kmers. Therefore, the elements in the feature vectors 
represent the frequencies of kmers. The default value of this parameter is False.}

\item{customprops}{the users can use their own indices to generate the feature vector. It should be a dict, 
the key is dinucleotide (string), and its corresponding value is a list type.}
}
\value{
A vector
}
\description{
The Pseudo Dinucleotide Composition Descriptor
}
\details{
This function calculates the pseudo dinucleotide composition Descriptor
}
\note{
if the user defined physicochemical indices have not been normalized, it should be normalized.
}
\examples{
 
x = 'GACTGAACTGCACTTTGGTTTCATATTATTTGCTC'
extrDNAPseDNC(x)

}
\references{
Chen W, Feng P M, Lin H, et al. iRSpot-PseDNC: identify recombination spots with pseudo dinucleotide composition. 
\emph{Nucleic acids research}, 2013: gks1450.
}
\seealso{
See \code{\link{extrDNAPseKNC}}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\keyword{PseDNC}
\keyword{extract}
