#!/usr/bin/env python
import os
import lagrange
data = """\
### begin data
{'area_adjacency': [[1, 1, 1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1, 1, 1],
                    [1, 1, 1, 1, 1, 1, 1]],
 'area_dispersal': [[[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                     [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]]],
 'area_labels': ['A', 'B', 'C', 'D', 'E', 'F', 'G'],
 'base_rates': '__estimate__',
 'dispersal_durations': [1000.0],
 'dm_symmetric_entry': True,
 'excluded_ranges': [],
 'lagrange_version': '20120508',
 'max_range_size': 7,
 'model_name': 'Cyrtandra_M0',
 'newick_trees': [{'included': '__all__',
                   'name': 'Tree0',
                   'newick': '((((((((C_sp_C0018:8.285191793, ((C_sp_C0016:7.566993756, (C_anthropophagorum_C0114:7.359678858, (C_sp_C0019:4.190722569, C_sp_C0020:4.190722569)N5:3.168956289)N6:0.2073148974)N7:0.4590544157, (C_milnei_C0113:0.7181980375, C_leucantha_C0116:0.7181980375)N10:7.307850134)N11:0.2591436218)N12:3.931578947, (((C_richii_C0072:6.700713649, C_aurantiicarpa_C0076:6.700713649)N15:0.710793934, (C_sp_C0112:6.648884924, (C_cf_richii_C0068:6.441570027, C_pogonantha_C0071:6.441570027)N19:0.2073148974)N20:0.7626226583)N21:0.3628010705, (((C_ootensis_var_ootensis_C0061:4.146297948, (C_feaniana_C0059:3.938983051, C_ootensis_var_mollissima_C0060:3.938983051)N25:0.2073148974)N26:0.6589652096, (C_ootensis_var_mollissima_C0063:4.0426405, C_ootensis_var_mollissima_C0132:4.0426405)N29:0.7626226583)N30:1.125423729, (C_jonesii_C0064:2.354504906, (C_thibaultii_C0062:0.5108831401, C_nukukivensis_C0065:0.5108831401)N34:1.843621766)N35:3.57618198)N36:1.843621766)N37:4.442462087)N38:1.791793042, (((C_samoensis_C0030:7.515165031, C_samoensis_C0031:7.515165031)N41:0.5627118644, (C_kusaimontana_C0033:4.753434434, C_urvillei_C0034:4.753434434)N44:3.324442462)N45:2.398929527, (C_pulchella_C0029:3.072702944, C_ompressa_C0074:3.072702944)N48:7.404103479)N49:3.53175736)N50:4.242551293, (C_cf_occulta_C0119:4.398037467, (C_sp_C0017:2.199018733, C_occulta_C0017:2.199018733)N54:2.199018733)N55:13.85307761)N56:0.4590544157, ((C_sandwicensis_C0045:5.168064228, (C_wagneri_C0013:5.06440678, ((C_munroi_C0104:3.783496878, (C_propinqua_C0039:3.583586084, C_cordifolia_C0048:3.583586084)N62:0.1999107939)N63:0.05182872435, (C_laxiflora_C0037:3.679839429, C_sp_C0050:3.679839429)N66:0.1554861731)N67:1.229081178)N68:0.1036574487)N69:0.1480820696, ((C_longifolia_C0023:2.917216771, (C_grandiflora_C0046:0.8736842105, (C_hawaiensis_C0038:0.6663693131, C_kaulantha_C0041:0.6663693131)N74:0.2073148974)N75:2.04353256)N76:0.6663693131, ((C_tintinabula_C0012:0.4664585192, C_spathulata_C0102:0.4664585192)N79:0.1480820696, (C_grayana_C0103:0.05182872435, C_grayi_C0105:0.05182872435)N82:0.5627118644)N83:2.969045495)N84:1.732560214)N85:13.39402319)N86:16.45191793, (C_coccinea_C0089:5.471632471, (C_calpidicarpa_C0040:5.012578055, (C_wawrae_C0022:3.887154326, ((C_wainihaensis_C0021:1.947279215, C_kauaiensis_C0026:1.947279215)N92:0.1999107939, (C_kealiae_spp_kealiae_C0035:1.947279215, C_kealiae_spp_urceolata_C0054:1.947279215)N95:0.1999107939)N96:1.739964318)N97:1.125423729)N98:0.4590544157)N99:29.69045495)N100:2.302676182, (C_sulcata_C0100:18.71016949, (C_sp_C0095:17.28117752, (C_sp_C0092:4.190722569, (C_sp_C0094:0.4664585192, C_pendula_C0098:0.4664585192)N106:3.72426405)N107:13.09045495)N108:1.428991971)N109:18.75459411)N110:4.035236396, (C_sp_C0093:24.48537021, (C_sp_C0096:12.47591436, C_picta_C0097:12.47591436)N114:12.00945584)N115:17.01462979)N116;',
                   'root_age': 41.500000000699998}],
 'ranges': [(),
            (0,),
            (0, 1),
            (0, 1, 2),
            (0, 1, 2, 3),
            (0, 1, 2, 3, 4),
            (0, 1, 2, 3, 4, 5),
            (0, 1, 2, 3, 4, 5, 6),
            (0, 1, 2, 3, 4, 6),
            (0, 1, 2, 3, 5),
            (0, 1, 2, 3, 5, 6),
            (0, 1, 2, 3, 6),
            (0, 1, 2, 4),
            (0, 1, 2, 4, 5),
            (0, 1, 2, 4, 5, 6),
            (0, 1, 2, 4, 6),
            (0, 1, 2, 5),
            (0, 1, 2, 5, 6),
            (0, 1, 2, 6),
            (0, 1, 3),
            (0, 1, 3, 4),
            (0, 1, 3, 4, 5),
            (0, 1, 3, 4, 5, 6),
            (0, 1, 3, 4, 6),
            (0, 1, 3, 5),
            (0, 1, 3, 5, 6),
            (0, 1, 3, 6),
            (0, 1, 4),
            (0, 1, 4, 5),
            (0, 1, 4, 5, 6),
            (0, 1, 4, 6),
            (0, 1, 5),
            (0, 1, 5, 6),
            (0, 1, 6),
            (0, 2),
            (0, 2, 3),
            (0, 2, 3, 4),
            (0, 2, 3, 4, 5),
            (0, 2, 3, 4, 5, 6),
            (0, 2, 3, 4, 6),
            (0, 2, 3, 5),
            (0, 2, 3, 5, 6),
            (0, 2, 3, 6),
            (0, 2, 4),
            (0, 2, 4, 5),
            (0, 2, 4, 5, 6),
            (0, 2, 4, 6),
            (0, 2, 5),
            (0, 2, 5, 6),
            (0, 2, 6),
            (0, 3),
            (0, 3, 4),
            (0, 3, 4, 5),
            (0, 3, 4, 5, 6),
            (0, 3, 4, 6),
            (0, 3, 5),
            (0, 3, 5, 6),
            (0, 3, 6),
            (0, 4),
            (0, 4, 5),
            (0, 4, 5, 6),
            (0, 4, 6),
            (0, 5),
            (0, 5, 6),
            (0, 6),
            (1,),
            (1, 2),
            (1, 2, 3),
            (1, 2, 3, 4),
            (1, 2, 3, 4, 5),
            (1, 2, 3, 4, 5, 6),
            (1, 2, 3, 4, 6),
            (1, 2, 3, 5),
            (1, 2, 3, 5, 6),
            (1, 2, 3, 6),
            (1, 2, 4),
            (1, 2, 4, 5),
            (1, 2, 4, 5, 6),
            (1, 2, 4, 6),
            (1, 2, 5),
            (1, 2, 5, 6),
            (1, 2, 6),
            (1, 3),
            (1, 3, 4),
            (1, 3, 4, 5),
            (1, 3, 4, 5, 6),
            (1, 3, 4, 6),
            (1, 3, 5),
            (1, 3, 5, 6),
            (1, 3, 6),
            (1, 4),
            (1, 4, 5),
            (1, 4, 5, 6),
            (1, 4, 6),
            (1, 5),
            (1, 5, 6),
            (1, 6),
            (2,),
            (2, 3),
            (2, 3, 4),
            (2, 3, 4, 5),
            (2, 3, 4, 5, 6),
            (2, 3, 4, 6),
            (2, 3, 5),
            (2, 3, 5, 6),
            (2, 3, 6),
            (2, 4),
            (2, 4, 5),
            (2, 4, 5, 6),
            (2, 4, 6),
            (2, 5),
            (2, 5, 6),
            (2, 6),
            (3,),
            (3, 4),
            (3, 4, 5),
            (3, 4, 5, 6),
            (3, 4, 6),
            (3, 5),
            (3, 5, 6),
            (3, 6),
            (4,),
            (4, 5),
            (4, 5, 6),
            (4, 6),
            (5,),
            (5, 6),
            (6,)],
 'taxa': ['C_feaniana_C0059',
          'C_ootensis_var_mollissima_C0060',
          'C_ootensis_var_ootensis_C0061',
          'C_ootensis_var_mollissima_C0063',
          'C_ootensis_var_mollissima_C0132',
          'C_thibaultii_C0062',
          'C_nukukivensis_C0065',
          'C_jonesii_C0064',
          'C_cf_richii_C0068',
          'C_pogonantha_C0071',
          'C_sp_C0112',
          'C_richii_C0072',
          'C_aurantiicarpa_C0076',
          'C_sp_C0019',
          'C_sp_C0020',
          'C_anthropophagorum_C0114',
          'C_sp_C0016',
          'C_milnei_C0113',
          'C_leucantha_C0116',
          'C_sp_C0018',
          'C_samoensis_C0030',
          'C_samoensis_C0031',
          'C_kusaimontana_C0033',
          'C_urvillei_C0034',
          'C_pulchella_C0029',
          'C_ompressa_C0074',
          'C_sp_C0017',
          'C_occulta_C0017',
          'C_cf_occulta_C0119',
          'C_grayana_C0103',
          'C_grayi_C0105',
          'C_tintinabula_C0012',
          'C_spathulata_C0102',
          'C_hawaiensis_C0038',
          'C_kaulantha_C0041',
          'C_grandiflora_C0046',
          'C_longifolia_C0023',
          'C_laxiflora_C0037',
          'C_sp_C0050',
          'C_propinqua_C0039',
          'C_cordifolia_C0048',
          'C_munroi_C0104',
          'C_wagneri_C0013',
          'C_sandwicensis_C0045',
          'C_wainihaensis_C0021',
          'C_kauaiensis_C0026',
          'C_kealiae_spp_kealiae_C0035',
          'C_kealiae_spp_urceolata_C0054',
          'C_wawrae_C0022',
          'C_calpidicarpa_C0040',
          'C_coccinea_C0089',
          'C_sulcata_C0100',
          'C_sp_C0094',
          'C_pendula_C0098',
          'C_sp_C0092',
          'C_sp_C0095',
          'C_sp_C0096',
          'C_picta_C0097',
          'C_sp_C0093'],
 'taxon_range_data': {'C_anthropophagorum_C0114': (2,),
                      'C_aurantiicarpa_C0076': (1,),
                      'C_calpidicarpa_C0040': (5,),
                      'C_cf_occulta_C0119': (2,),
                      'C_cf_richii_C0068': (1,),
                      'C_coccinea_C0089': (6,),
                      'C_cordifolia_C0048': (5,),
                      'C_feaniana_C0059': (0,),
                      'C_grandiflora_C0046': (5,),
                      'C_grayana_C0103': (5,),
                      'C_grayi_C0105': (5,),
                      'C_hawaiensis_C0038': (5,),
                      'C_jonesii_C0064': (0,),
                      'C_kauaiensis_C0026': (5,),
                      'C_kaulantha_C0041': (5,),
                      'C_kealiae_spp_kealiae_C0035': (5,),
                      'C_kealiae_spp_urceolata_C0054': (5,),
                      'C_kusaimontana_C0033': (4,),
                      'C_laxiflora_C0037': (5,),
                      'C_leucantha_C0116': (2,),
                      'C_longifolia_C0023': (5,),
                      'C_milnei_C0113': (2,),
                      'C_munroi_C0104': (5,),
                      'C_nukukivensis_C0065': (0,),
                      'C_occulta_C0017': (2,),
                      'C_ompressa_C0074': (1,),
                      'C_ootensis_var_mollissima_C0060': (0,),
                      'C_ootensis_var_mollissima_C0063': (0,),
                      'C_ootensis_var_mollissima_C0132': (0,),
                      'C_ootensis_var_ootensis_C0061': (0,),
                      'C_pendula_C0098': (6,),
                      'C_picta_C0097': (6,),
                      'C_pogonantha_C0071': (1,),
                      'C_propinqua_C0039': (5,),
                      'C_pulchella_C0029': (1,),
                      'C_richii_C0072': (1,),
                      'C_samoensis_C0030': (1,),
                      'C_samoensis_C0031': (3,),
                      'C_sandwicensis_C0045': (5,),
                      'C_sp_C0016': (2,),
                      'C_sp_C0017': (2,),
                      'C_sp_C0018': (2,),
                      'C_sp_C0019': (2,),
                      'C_sp_C0020': (2,),
                      'C_sp_C0050': (5,),
                      'C_sp_C0092': (6,),
                      'C_sp_C0093': (6,),
                      'C_sp_C0094': (6,),
                      'C_sp_C0095': (6,),
                      'C_sp_C0096': (6,),
                      'C_sp_C0112': (2,),
                      'C_spathulata_C0102': (5,),
                      'C_sulcata_C0100': (6,),
                      'C_thibaultii_C0062': (0,),
                      'C_tintinabula_C0012': (5,),
                      'C_urvillei_C0034': (4,),
                      'C_wagneri_C0013': (5,),
                      'C_wainihaensis_C0021': (5,),
                      'C_wawrae_C0022': (5,)}}
### end data
"""

i = 0
while 1:
    if not i:
        outfname = "Cyrtandra_M0.results.txt"
    else:
        outfname = "Cyrtandra_M0.results-"+str(i)+".txt"
    if not os.path.exists(outfname): break
    i += 1
outfile = open(outfname, "w")
lagrange.output.log(lagrange.msg, outfile, tee=True)
model, tree, data, nodelabels, base_rates = lagrange.input.eval_decmodel(data)
lagrange.output.ascii_tree(outfile, tree, model, data, tee=True)
if base_rates != "__estimate__":
    d, e = base_rates
else:
    d, e = lagrange.output.optimize_dispersal_extinction(outfile, tree, model, tee=True)
if nodelabels:
    if nodelabels == "__all__":
        nodelabels = None
    lagrange.output.ancsplits(outfile, tree, model, d, e, nodelabels=nodelabels, tee=True)
