% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scree.R
\name{scree}
\alias{scree}
\title{Draws a scree plot.}
\usage{
scree(x, dimensions = 4, dist_meth = "binary")
}
\arguments{
\item{x}{Consolidated binary matrix with grouping information in column 2.}

\item{dimensions}{Number of dimensions to plot. Set to 4 by default.}

\item{dist_meth}{Distance method. Set to "binary" by default. Other options are "euclidean", "maximum", "manhattan", "canberra", or "minkowski".}
}
\value{
Scree plot.
}
\description{
Creates a scree plot for the non-metric multidimensional scaling plot. This indicates the optimum number of dimensions to use to minimise the stress value. The stress value is indicated by a red dotted line at 0.15. Values equal to or below this are considered acceptable.
}
\examples{
mat = BinMatInput_ordination
scree(mat)


}
