% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdSVD_lapack}
\alias{bdSVD_lapack}
\title{Complete SVD with Lapack Functions for DelayedArray and RObjects}
\usage{
bdSVD_lapack(X, bcenter = TRUE, bscale = TRUE, complete = FALSE)
}
\arguments{
\item{X}{numerical or Delayed Array matrix}

\item{bcenter}{(optional, defalut = TRUE) . If center is TRUE then centering is done by subtracting the column means (omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.}

\item{bscale}{(optional, defalut = TRUE) .  If scale is TRUE then scaling is done by dividing the (centered) columns of x by their standard deviations if center is TRUE, and the root mean square otherwise. If scale is FALSE, no scaling is done.}

\item{complete}{(optional, defalut = FALSE) . If complete is TRUE svd function returns complete u and v}
}
\value{
u eigenvectors of AA^t, mxn and column orthogonal matrix

v eigenvectors of A^tA, nxn orthogonal matrix

d singular values, nxn diagonal matrix (non-negative real values)
}
\description{
This function performs a complete svd decomposition of numerical matrix or Delayed Array with
}
\examples{

library(BigDataStatMeth)
n <- 500
A <- matrix(rnorm(n*n), nrow=n, ncol=n)

# svd without normalization
decsvd <- bdSVD_lapack( A, bscale = FALSE, bcenter = FALSE ) # No matrix normalization
decsvd$d
decsvd$u

# svd with normalization
decvsd <- bdSVD_lapack( A, bscale = TRUE, bcenter = TRUE) # Matrix normalization
decvsd <- bdSVD_lapack( A ) # Matrix normalization too
decsvd$d
decsvd$u

# svd with scaled matrix (sd)
decvsd <- bdSVD_lapack( A, bscale = TRUE, bcenter = FALSE) # Scaled matrix

}
