% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiProbitPartialR.R
\name{summary.optimrml}
\alias{summary.optimrml}
\title{Summary method for class 'optimrml'}
\usage{
\method{summary}{optimrml}(object, ...)
}
\arguments{
\item{object}{Object of class \code{optimrml}}

\item{...}{unused}
}
\value{
matrix summary of estimates. The columns are \describe{
\item{Estimate}{Maximum likelihood point estimate}

\item{Std. Error}{Asymptotic standard error estimate of maximum likelihood point estimators using numerical hessian}

\item{z value}{z value for zero value null hypothesis using asymptotic standard error estimate}

\item{Pr(>|z|)}{P value for a two sided null hyptothesis test using the z value}
}
}
\description{
Summary method for class 'optimrml'
}
\examples{
data('Mroz87',package = 'sampleSelection')
Mroz87$Z = Mroz87$lfp*(Mroz87$wage >= 5)

f1 = BiProbitPartial(Z ~ educ + age + kids5 + kids618 + nwifeinc | educ + exper + city, 
     data = Mroz87, philosophy = "frequentist")
summary(f1)

b1 = BiProbitPartial(Z ~ educ + age + kids5 + kids618 + nwifeinc | educ + exper + city, 
    data = Mroz87, philosophy = "bayesian", 
    control = list(beta = f1$par[1:(length(f1$par)-1)], rho = tail(f1$par,1)))
summary(b1)

}
