// Generated by rstantools.  Do not edit by hand.

/*
    BeeGUTS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BeeGUTS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BeeGUTS.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_GUTS_IT_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_GUTS_IT");
    reader.add_event(3, 3, "include", "/include/license.stan");
    reader.add_event(3, 0, "start", "/include/license.stan");
    reader.add_event(17, 14, "end", "/include/license.stan");
    reader.add_event(17, 4, "restart", "model_GUTS_IT");
    reader.add_event(20, 7, "include", "/include/common_stan_functions.stan");
    reader.add_event(20, 0, "start", "/include/common_stan_functions.stan");
    reader.add_event(87, 67, "end", "/include/common_stan_functions.stan");
    reader.add_event(87, 8, "restart", "model_GUTS_IT");
    reader.add_event(134, 55, "include", "/include/data_guts.stan");
    reader.add_event(134, 0, "start", "/include/data_guts.stan");
    reader.add_event(171, 37, "end", "/include/data_guts.stan");
    reader.add_event(171, 56, "restart", "model_GUTS_IT");
    reader.add_event(266, 151, "include", "/include/gen_quantities_guts.stan");
    reader.add_event(266, 0, "start", "/include/gen_quantities_guts.stan");
    reader.add_event(287, 21, "end", "/include/gen_quantities_guts.stan");
    reader.add_event(287, 152, "restart", "model_GUTS_IT");
    reader.add_event(291, 154, "end", "model_GUTS_IT");
    return reader;
}
template <typename T0__, typename T1__>
int
find_interval_elem(const T0__& x,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& sorted,
                       const int& start_ind, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        int res(0);
        (void) res;  // dummy to suppress unused var warning
        stan::math::fill(res, std::numeric_limits<int>::min());
        current_statement_begin__ = 28;
        int N(0);
        (void) N;  // dummy to suppress unused var warning
        stan::math::fill(N, std::numeric_limits<int>::min());
        current_statement_begin__ = 29;
        int max_iter(0);
        (void) max_iter;  // dummy to suppress unused var warning
        stan::math::fill(max_iter, std::numeric_limits<int>::min());
        current_statement_begin__ = 30;
        local_scalar_t__ left(DUMMY_VAR__);
        (void) left;  // dummy to suppress unused var warning
        stan::math::initialize(left, DUMMY_VAR__);
        stan::math::fill(left, DUMMY_VAR__);
        current_statement_begin__ = 31;
        local_scalar_t__ right(DUMMY_VAR__);
        (void) right;  // dummy to suppress unused var warning
        stan::math::initialize(right, DUMMY_VAR__);
        stan::math::fill(right, DUMMY_VAR__);
        current_statement_begin__ = 32;
        int left_ind(0);
        (void) left_ind;  // dummy to suppress unused var warning
        stan::math::fill(left_ind, std::numeric_limits<int>::min());
        current_statement_begin__ = 33;
        int right_ind(0);
        (void) right_ind;  // dummy to suppress unused var warning
        stan::math::fill(right_ind, std::numeric_limits<int>::min());
        current_statement_begin__ = 34;
        int iter(0);
        (void) iter;  // dummy to suppress unused var warning
        stan::math::fill(iter, std::numeric_limits<int>::min());
        current_statement_begin__ = 36;
        stan::math::assign(N, num_elements(sorted));
        current_statement_begin__ = 38;
        if (as_bool(logical_eq(N, 0))) {
            current_statement_begin__ = 38;
            return stan::math::promote_scalar<fun_return_scalar_t__>(0);
        }
        current_statement_begin__ = 40;
        stan::math::assign(left_ind, start_ind);
        current_statement_begin__ = 41;
        stan::math::assign(right_ind, N);
        current_statement_begin__ = 43;
        stan::math::assign(max_iter, (100 * N));
        current_statement_begin__ = 44;
        stan::math::assign(left, (get_base1(sorted, left_ind, "sorted", 1) - x));
        current_statement_begin__ = 45;
        stan::math::assign(right, (get_base1(sorted, right_ind, "sorted", 1) - x));
        current_statement_begin__ = 47;
        if (as_bool(logical_lte(0, left))) {
            current_statement_begin__ = 47;
            return stan::math::promote_scalar<fun_return_scalar_t__>((left_ind - 1));
        }
        current_statement_begin__ = 48;
        if (as_bool(logical_eq(0, right))) {
            current_statement_begin__ = 48;
            return stan::math::promote_scalar<fun_return_scalar_t__>((N - 1));
        }
        current_statement_begin__ = 49;
        if (as_bool(logical_gt(0, right))) {
            current_statement_begin__ = 49;
            return stan::math::promote_scalar<fun_return_scalar_t__>(N);
        }
        current_statement_begin__ = 51;
        stan::math::assign(iter, 1);
        current_statement_begin__ = 52;
        while (as_bool((primitive_value(logical_gt((right_ind - left_ind), 1)) && primitive_value(logical_neq(iter, max_iter))))) {
            {
            current_statement_begin__ = 53;
            int mid_ind(0);
            (void) mid_ind;  // dummy to suppress unused var warning
            stan::math::fill(mid_ind, std::numeric_limits<int>::min());
            current_statement_begin__ = 54;
            local_scalar_t__ mid(DUMMY_VAR__);
            (void) mid;  // dummy to suppress unused var warning
            stan::math::initialize(mid, DUMMY_VAR__);
            stan::math::fill(mid, DUMMY_VAR__);
            current_statement_begin__ = 56;
            stan::math::assign(mid_ind, divide((left_ind + right_ind), 2));
            current_statement_begin__ = 57;
            stan::math::assign(mid, (get_base1(sorted, mid_ind, "sorted", 1) - x));
            current_statement_begin__ = 58;
            if (as_bool(logical_eq(mid, 0))) {
                current_statement_begin__ = 58;
                return stan::math::promote_scalar<fun_return_scalar_t__>((mid_ind - 1));
            }
            current_statement_begin__ = 59;
            if (as_bool(logical_lt((left * mid), 0))) {
                current_statement_begin__ = 59;
                stan::math::assign(right, mid);
                current_statement_begin__ = 59;
                stan::math::assign(right_ind, mid_ind);
            }
            current_statement_begin__ = 60;
            if (as_bool(logical_lt((right * mid), 0))) {
                current_statement_begin__ = 60;
                stan::math::assign(left, mid);
                current_statement_begin__ = 60;
                stan::math::assign(left_ind, mid_ind);
            }
            current_statement_begin__ = 61;
            stan::math::assign(iter, (iter + 1));
            }
        }
        current_statement_begin__ = 63;
        if (as_bool(logical_eq(iter, max_iter))) {
            current_statement_begin__ = 63;
            if (pstream__) {
                stan_print(pstream__,"Maximum number of iterations reached.");
                *pstream__ << std::endl;
            }
        }
        current_statement_begin__ = 64;
        return stan::math::promote_scalar<fun_return_scalar_t__>(left_ind);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct find_interval_elem_functor__ {
    template <typename T0__, typename T1__>
        int
    operator()(const T0__& x,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& sorted,
                       const int& start_ind, std::ostream* pstream__) const {
        return find_interval_elem(x, sorted, start_ind, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
linearInterp(const T0__& t_x,
                 const T1__& t_before,
                 const T2__& t_after,
                 const T3__& y_before,
                 const T4__& y_after, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 68;
        local_scalar_t__ linInterp_hat(DUMMY_VAR__);
        (void) linInterp_hat;  // dummy to suppress unused var warning
        stan::math::initialize(linInterp_hat, DUMMY_VAR__);
        stan::math::fill(linInterp_hat, DUMMY_VAR__);
        current_statement_begin__ = 70;
        stan::math::assign(linInterp_hat, (y_before + (((t_x - t_before) * (y_after - y_before)) / (t_after - t_before))));
        current_statement_begin__ = 72;
        return stan::math::promote_scalar<fun_return_scalar_t__>(linInterp_hat);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linearInterp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& t_x,
                 const T1__& t_before,
                 const T2__& t_after,
                 const T3__& y_before,
                 const T4__& y_after, std::ostream* pstream__) const {
        return linearInterp(t_x, t_before, t_after, y_before, y_after, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
loglogistic_2_lpdf(const T0__& y_hat,
                       const T1__& mw,
                       const T2__& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 77;
        return stan::math::promote_scalar<fun_return_scalar_t__>((((stan::math::log(beta) - stan::math::log(mw)) + ((beta - 1) * (stan::math::log(y_hat) - stan::math::log(mw)))) - (2 * log1p_exp((beta * (stan::math::log(y_hat) - stan::math::log(mw)))))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
loglogistic_2_lpdf(const T0__& y_hat,
                       const T1__& mw,
                       const T2__& beta, std::ostream* pstream__) {
    return loglogistic_2_lpdf<false>(y_hat,mw,beta, pstream__);
}
struct loglogistic_2_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& y_hat,
                       const T1__& mw,
                       const T2__& beta, std::ostream* pstream__) const {
        return loglogistic_2_lpdf(y_hat, mw, beta, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
loglogistic_2_lcdf(const T0__& y_hat,
                       const T1__& mw,
                       const T2__& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 82;
        return stan::math::promote_scalar<fun_return_scalar_t__>(-(log1p_exp((-(beta) * (stan::math::log(y_hat) - stan::math::log(mw))))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglogistic_2_lcdf_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& y_hat,
                       const T1__& mw,
                       const T2__& beta, std::ostream* pstream__) const {
        return loglogistic_2_lcdf(y_hat, mw, beta, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
loglogistic_2_lccdf(const T0__& y_hat,
                        const T1__& mw,
                        const T2__& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 86;
        return stan::math::promote_scalar<fun_return_scalar_t__>(-(log1p_exp((beta * (stan::math::log(y_hat) - stan::math::log(mw))))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglogistic_2_lccdf_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& y_hat,
                        const T1__& mw,
                        const T2__& beta, std::ostream* pstream__) const {
        return loglogistic_2_lccdf(y_hat, mw, beta, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
TKTD_varIT(const T0__& t,
               const std::vector<T1__>& y,
               const std::vector<T2__>& theta,
               const std::vector<T3__>& x_r,
               const std::vector<int>& x_i, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 96;
        local_scalar_t__ kd(DUMMY_VAR__);
        (void) kd;  // dummy to suppress unused var warning
        stan::math::initialize(kd, DUMMY_VAR__);
        stan::math::fill(kd, DUMMY_VAR__);
        stan::math::assign(kd,get_base1(theta, 1, "theta", 1));
        current_statement_begin__ = 99;
        validate_non_negative_index("dy_dt", "1", 1);
        std::vector<local_scalar_t__  > dy_dt(1, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(dy_dt, DUMMY_VAR__);
        stan::math::fill(dy_dt, DUMMY_VAR__);
        current_statement_begin__ = 102;
        int Nconc(0);
        (void) Nconc;  // dummy to suppress unused var warning
        stan::math::fill(Nconc, std::numeric_limits<int>::min());
        stan::math::assign(Nconc,get_base1(x_i, 1, "x_i", 1));
        current_statement_begin__ = 104;
        validate_non_negative_index("tconc", "Nconc", Nconc);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tconc(Nconc);
        stan::math::initialize(tconc, DUMMY_VAR__);
        stan::math::fill(tconc, DUMMY_VAR__);
        stan::math::assign(tconc,to_vector(stan::model::rvalue(x_r, stan::model::cons_list(stan::model::index_min_max(1, Nconc), stan::model::nil_index_list()), "x_r")));
        current_statement_begin__ = 105;
        validate_non_negative_index("conc", "Nconc", Nconc);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> conc(Nconc);
        stan::math::initialize(conc, DUMMY_VAR__);
        stan::math::fill(conc, DUMMY_VAR__);
        stan::math::assign(conc,to_vector(stan::model::rvalue(x_r, stan::model::cons_list(stan::model::index_min_max((Nconc + 1), (2 * Nconc)), stan::model::nil_index_list()), "x_r")));
        current_statement_begin__ = 107;
        int pulse_index(0);
        (void) pulse_index;  // dummy to suppress unused var warning
        stan::math::fill(pulse_index, std::numeric_limits<int>::min());
        stan::math::assign(pulse_index,find_interval_elem(t, tconc, 1, pstream__));
        current_statement_begin__ = 110;
        local_scalar_t__ conc_linInterp(DUMMY_VAR__);
        (void) conc_linInterp;  // dummy to suppress unused var warning
        stan::math::initialize(conc_linInterp, DUMMY_VAR__);
        stan::math::fill(conc_linInterp, DUMMY_VAR__);
        stan::math::assign(conc_linInterp,(logical_neq(pulse_index, 0) ? stan::math::promote_scalar<local_scalar_t__>(linearInterp(t, get_base1(tconc, pulse_index, "tconc", 1), get_base1(tconc, (pulse_index + 1), "tconc", 1), get_base1(conc, pulse_index, "conc", 1), get_base1(conc, (pulse_index + 1), "conc", 1), pstream__)) : stan::math::promote_scalar<local_scalar_t__>(get_base1(conc, 1, "conc", 1)) ));
        current_statement_begin__ = 113;
        stan::model::assign(dy_dt, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    (kd * (conc_linInterp - get_base1(y, 1, "y", 1))), 
                    "assigning variable dy_dt");
        current_statement_begin__ = 115;
        return stan::math::promote_scalar<fun_return_scalar_t__>(dy_dt);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct TKTD_varIT_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& t,
               const std::vector<T1__>& y,
               const std::vector<T2__>& theta,
               const std::vector<T3__>& x_r,
               const std::vector<int>& x_i, std::ostream* pstream__) const {
        return TKTD_varIT(t, y, theta, x_r, x_i, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
solve_TKTD_varIT(const std::vector<T0__>& y0,
                     const T1__& t0,
                     const std::vector<T2__>& ts,
                     const std::vector<T3__>& theta,
                     const std::vector<T4__>& tconc,
                     const std::vector<T5__>& conc,
                     const std::vector<T6__>& odeParam, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 120;
        validate_non_negative_index("x_i", "1", 1);
        std::vector<int  > x_i(1, int(0));
        stan::math::fill(x_i, std::numeric_limits<int>::min());
        current_statement_begin__ = 121;
        stan::model::assign(x_i, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    size(tconc), 
                    "assigning variable x_i");
        current_statement_begin__ = 123;
        return stan::math::promote_scalar<fun_return_scalar_t__>(to_matrix(integrate_ode_rk45(TKTD_varIT_functor__(), y0, t0, ts, theta, to_array_1d(append_row(to_vector(tconc), to_vector(conc))), x_i, pstream__, get_base1(odeParam, 1, "odeParam", 1), get_base1(odeParam, 2, "odeParam", 1), get_base1(odeParam, 3, "odeParam", 1))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct solve_TKTD_varIT_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const std::vector<T0__>& y0,
                     const T1__& t0,
                     const std::vector<T2__>& ts,
                     const std::vector<T3__>& theta,
                     const std::vector<T4__>& tconc,
                     const std::vector<T5__>& conc,
                     const std::vector<T6__>& odeParam, std::ostream* pstream__) const {
        return solve_TKTD_varIT(y0, t0, ts, theta, tconc, conc, odeParam, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_GUTS_IT
  : public stan::model::model_base_crtp<model_GUTS_IT> {
private:
        int nDatasets;
        int nGroup;
        std::vector<int> groupDataset;
        int nData_conc;
        std::vector<double> conc;
        std::vector<double> tconc;
        std::vector<int> idC_lw;
        std::vector<int> idC_up;
        int nData_Nsurv;
        std::vector<int> Nsurv;
        std::vector<int> Nprec;
        std::vector<double> tNsurv;
        std::vector<int> idS_lw;
        std::vector<int> idS_up;
        double hbMean_log10;
        double hbSD_log10;
        double kdMean_log10;
        double kdSD_log10;
        double relTol;
        double absTol;
        int maxSteps;
        int distribution;
        double mwMean_log10;
        double mwSD_log10;
        double betaMin_log10;
        double betaMax_log10;
        std::vector<double> y0;
        std::vector<double> odeParam;
        std::vector<double> tNsurv_ode;
        std::vector<double> tconc_ode;
public:
    model_GUTS_IT(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_GUTS_IT(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_GUTS_IT_namespace::model_GUTS_IT";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 139;
            context__.validate_dims("data initialization", "nDatasets", "int", context__.to_vec());
            nDatasets = int(0);
            vals_i__ = context__.vals_i("nDatasets");
            pos__ = 0;
            nDatasets = vals_i__[pos__++];
            check_greater_or_equal(function__, "nDatasets", nDatasets, 1);
            current_statement_begin__ = 142;
            context__.validate_dims("data initialization", "nGroup", "int", context__.to_vec());
            nGroup = int(0);
            vals_i__ = context__.vals_i("nGroup");
            pos__ = 0;
            nGroup = vals_i__[pos__++];
            check_greater_or_equal(function__, "nGroup", nGroup, 1);
            current_statement_begin__ = 143;
            validate_non_negative_index("groupDataset", "nGroup", nGroup);
            context__.validate_dims("data initialization", "groupDataset", "int", context__.to_vec(nGroup));
            groupDataset = std::vector<int>(nGroup, int(0));
            vals_i__ = context__.vals_i("groupDataset");
            pos__ = 0;
            size_t groupDataset_k_0_max__ = nGroup;
            for (size_t k_0__ = 0; k_0__ < groupDataset_k_0_max__; ++k_0__) {
                groupDataset[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 146;
            context__.validate_dims("data initialization", "nData_conc", "int", context__.to_vec());
            nData_conc = int(0);
            vals_i__ = context__.vals_i("nData_conc");
            pos__ = 0;
            nData_conc = vals_i__[pos__++];
            check_greater_or_equal(function__, "nData_conc", nData_conc, 1);
            current_statement_begin__ = 147;
            validate_non_negative_index("conc", "nData_conc", nData_conc);
            context__.validate_dims("data initialization", "conc", "double", context__.to_vec(nData_conc));
            conc = std::vector<double>(nData_conc, double(0));
            vals_r__ = context__.vals_r("conc");
            pos__ = 0;
            size_t conc_k_0_max__ = nData_conc;
            for (size_t k_0__ = 0; k_0__ < conc_k_0_max__; ++k_0__) {
                conc[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 148;
            validate_non_negative_index("tconc", "nData_conc", nData_conc);
            context__.validate_dims("data initialization", "tconc", "double", context__.to_vec(nData_conc));
            tconc = std::vector<double>(nData_conc, double(0));
            vals_r__ = context__.vals_r("tconc");
            pos__ = 0;
            size_t tconc_k_0_max__ = nData_conc;
            for (size_t k_0__ = 0; k_0__ < tconc_k_0_max__; ++k_0__) {
                tconc[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 150;
            validate_non_negative_index("idC_lw", "nGroup", nGroup);
            context__.validate_dims("data initialization", "idC_lw", "int", context__.to_vec(nGroup));
            idC_lw = std::vector<int>(nGroup, int(0));
            vals_i__ = context__.vals_i("idC_lw");
            pos__ = 0;
            size_t idC_lw_k_0_max__ = nGroup;
            for (size_t k_0__ = 0; k_0__ < idC_lw_k_0_max__; ++k_0__) {
                idC_lw[k_0__] = vals_i__[pos__++];
            }
            size_t idC_lw_i_0_max__ = nGroup;
            for (size_t i_0__ = 0; i_0__ < idC_lw_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "idC_lw[i_0__]", idC_lw[i_0__], 1);
            }
            current_statement_begin__ = 151;
            validate_non_negative_index("idC_up", "nGroup", nGroup);
            context__.validate_dims("data initialization", "idC_up", "int", context__.to_vec(nGroup));
            idC_up = std::vector<int>(nGroup, int(0));
            vals_i__ = context__.vals_i("idC_up");
            pos__ = 0;
            size_t idC_up_k_0_max__ = nGroup;
            for (size_t k_0__ = 0; k_0__ < idC_up_k_0_max__; ++k_0__) {
                idC_up[k_0__] = vals_i__[pos__++];
            }
            size_t idC_up_i_0_max__ = nGroup;
            for (size_t i_0__ = 0; i_0__ < idC_up_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "idC_up[i_0__]", idC_up[i_0__], 1);
            }
            current_statement_begin__ = 154;
            context__.validate_dims("data initialization", "nData_Nsurv", "int", context__.to_vec());
            nData_Nsurv = int(0);
            vals_i__ = context__.vals_i("nData_Nsurv");
            pos__ = 0;
            nData_Nsurv = vals_i__[pos__++];
            check_greater_or_equal(function__, "nData_Nsurv", nData_Nsurv, 1);
            current_statement_begin__ = 155;
            validate_non_negative_index("Nsurv", "nData_Nsurv", nData_Nsurv);
            context__.validate_dims("data initialization", "Nsurv", "int", context__.to_vec(nData_Nsurv));
            Nsurv = std::vector<int>(nData_Nsurv, int(0));
            vals_i__ = context__.vals_i("Nsurv");
            pos__ = 0;
            size_t Nsurv_k_0_max__ = nData_Nsurv;
            for (size_t k_0__ = 0; k_0__ < Nsurv_k_0_max__; ++k_0__) {
                Nsurv[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 156;
            validate_non_negative_index("Nprec", "nData_Nsurv", nData_Nsurv);
            context__.validate_dims("data initialization", "Nprec", "int", context__.to_vec(nData_Nsurv));
            Nprec = std::vector<int>(nData_Nsurv, int(0));
            vals_i__ = context__.vals_i("Nprec");
            pos__ = 0;
            size_t Nprec_k_0_max__ = nData_Nsurv;
            for (size_t k_0__ = 0; k_0__ < Nprec_k_0_max__; ++k_0__) {
                Nprec[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 157;
            validate_non_negative_index("tNsurv", "nData_Nsurv", nData_Nsurv);
            context__.validate_dims("data initialization", "tNsurv", "double", context__.to_vec(nData_Nsurv));
            tNsurv = std::vector<double>(nData_Nsurv, double(0));
            vals_r__ = context__.vals_r("tNsurv");
            pos__ = 0;
            size_t tNsurv_k_0_max__ = nData_Nsurv;
            for (size_t k_0__ = 0; k_0__ < tNsurv_k_0_max__; ++k_0__) {
                tNsurv[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 159;
            validate_non_negative_index("idS_lw", "nGroup", nGroup);
            context__.validate_dims("data initialization", "idS_lw", "int", context__.to_vec(nGroup));
            idS_lw = std::vector<int>(nGroup, int(0));
            vals_i__ = context__.vals_i("idS_lw");
            pos__ = 0;
            size_t idS_lw_k_0_max__ = nGroup;
            for (size_t k_0__ = 0; k_0__ < idS_lw_k_0_max__; ++k_0__) {
                idS_lw[k_0__] = vals_i__[pos__++];
            }
            size_t idS_lw_i_0_max__ = nGroup;
            for (size_t i_0__ = 0; i_0__ < idS_lw_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "idS_lw[i_0__]", idS_lw[i_0__], 1);
            }
            current_statement_begin__ = 160;
            validate_non_negative_index("idS_up", "nGroup", nGroup);
            context__.validate_dims("data initialization", "idS_up", "int", context__.to_vec(nGroup));
            idS_up = std::vector<int>(nGroup, int(0));
            vals_i__ = context__.vals_i("idS_up");
            pos__ = 0;
            size_t idS_up_k_0_max__ = nGroup;
            for (size_t k_0__ = 0; k_0__ < idS_up_k_0_max__; ++k_0__) {
                idS_up[k_0__] = vals_i__[pos__++];
            }
            size_t idS_up_i_0_max__ = nGroup;
            for (size_t i_0__ = 0; i_0__ < idS_up_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "idS_up[i_0__]", idS_up[i_0__], 1);
            }
            current_statement_begin__ = 163;
            context__.validate_dims("data initialization", "hbMean_log10", "double", context__.to_vec());
            hbMean_log10 = double(0);
            vals_r__ = context__.vals_r("hbMean_log10");
            pos__ = 0;
            hbMean_log10 = vals_r__[pos__++];
            current_statement_begin__ = 164;
            context__.validate_dims("data initialization", "hbSD_log10", "double", context__.to_vec());
            hbSD_log10 = double(0);
            vals_r__ = context__.vals_r("hbSD_log10");
            pos__ = 0;
            hbSD_log10 = vals_r__[pos__++];
            current_statement_begin__ = 165;
            context__.validate_dims("data initialization", "kdMean_log10", "double", context__.to_vec());
            kdMean_log10 = double(0);
            vals_r__ = context__.vals_r("kdMean_log10");
            pos__ = 0;
            kdMean_log10 = vals_r__[pos__++];
            current_statement_begin__ = 166;
            context__.validate_dims("data initialization", "kdSD_log10", "double", context__.to_vec());
            kdSD_log10 = double(0);
            vals_r__ = context__.vals_r("kdSD_log10");
            pos__ = 0;
            kdSD_log10 = vals_r__[pos__++];
            current_statement_begin__ = 169;
            context__.validate_dims("data initialization", "relTol", "double", context__.to_vec());
            relTol = double(0);
            vals_r__ = context__.vals_r("relTol");
            pos__ = 0;
            relTol = vals_r__[pos__++];
            current_statement_begin__ = 170;
            context__.validate_dims("data initialization", "absTol", "double", context__.to_vec());
            absTol = double(0);
            vals_r__ = context__.vals_r("absTol");
            pos__ = 0;
            absTol = vals_r__[pos__++];
            current_statement_begin__ = 171;
            context__.validate_dims("data initialization", "maxSteps", "int", context__.to_vec());
            maxSteps = int(0);
            vals_i__ = context__.vals_i("maxSteps");
            pos__ = 0;
            maxSteps = vals_i__[pos__++];
            current_statement_begin__ = 173;
            context__.validate_dims("data initialization", "distribution", "int", context__.to_vec());
            distribution = int(0);
            vals_i__ = context__.vals_i("distribution");
            pos__ = 0;
            distribution = vals_i__[pos__++];
            current_statement_begin__ = 176;
            context__.validate_dims("data initialization", "mwMean_log10", "double", context__.to_vec());
            mwMean_log10 = double(0);
            vals_r__ = context__.vals_r("mwMean_log10");
            pos__ = 0;
            mwMean_log10 = vals_r__[pos__++];
            current_statement_begin__ = 177;
            context__.validate_dims("data initialization", "mwSD_log10", "double", context__.to_vec());
            mwSD_log10 = double(0);
            vals_r__ = context__.vals_r("mwSD_log10");
            pos__ = 0;
            mwSD_log10 = vals_r__[pos__++];
            current_statement_begin__ = 178;
            context__.validate_dims("data initialization", "betaMin_log10", "double", context__.to_vec());
            betaMin_log10 = double(0);
            vals_r__ = context__.vals_r("betaMin_log10");
            pos__ = 0;
            betaMin_log10 = vals_r__[pos__++];
            current_statement_begin__ = 179;
            context__.validate_dims("data initialization", "betaMax_log10", "double", context__.to_vec());
            betaMax_log10 = double(0);
            vals_r__ = context__.vals_r("betaMax_log10");
            pos__ = 0;
            betaMax_log10 = vals_r__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 183;
            validate_non_negative_index("y0", "1", 1);
            y0 = std::vector<double>(1, double(0));
            stan::math::fill(y0, DUMMY_VAR__);
            current_statement_begin__ = 184;
            validate_non_negative_index("odeParam", "3", 3);
            odeParam = std::vector<double>(3, double(0));
            stan::math::fill(odeParam, DUMMY_VAR__);
            current_statement_begin__ = 186;
            validate_non_negative_index("tNsurv_ode", "nData_Nsurv", nData_Nsurv);
            tNsurv_ode = std::vector<double>(nData_Nsurv, double(0));
            stan::math::fill(tNsurv_ode, DUMMY_VAR__);
            current_statement_begin__ = 187;
            validate_non_negative_index("tconc_ode", "nData_conc", nData_conc);
            tconc_ode = std::vector<double>(nData_conc, double(0));
            stan::math::fill(tconc_ode, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 189;
            stan::model::assign(y0, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        1e-20, 
                        "assigning variable y0");
            current_statement_begin__ = 192;
            stan::model::assign(odeParam, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        relTol, 
                        "assigning variable odeParam");
            current_statement_begin__ = 193;
            stan::model::assign(odeParam, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        absTol, 
                        "assigning variable odeParam");
            current_statement_begin__ = 194;
            stan::model::assign(odeParam, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        maxSteps, 
                        "assigning variable odeParam");
            current_statement_begin__ = 196;
            for (int gr = 1; gr <= nGroup; ++gr) {
                current_statement_begin__ = 197;
                stan::model::assign(tNsurv_ode, 
                            stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), 
                            stan::model::rvalue(tNsurv, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "tNsurv"), 
                            "assigning variable tNsurv_ode");
                current_statement_begin__ = 198;
                stan::model::assign(tNsurv_ode, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(idS_lw, gr, "idS_lw", 1)), stan::model::nil_index_list()), 
                            (get_base1(tNsurv, get_base1(idS_lw, gr, "idS_lw", 1), "tNsurv", 1) + 1e-9), 
                            "assigning variable tNsurv_ode");
                current_statement_begin__ = 199;
                stan::model::assign(tconc_ode, 
                            stan::model::cons_list(stan::model::index_min_max(get_base1(idC_lw, gr, "idC_lw", 1), get_base1(idC_up, gr, "idC_up", 1)), stan::model::nil_index_list()), 
                            stan::model::rvalue(tconc, stan::model::cons_list(stan::model::index_min_max(get_base1(idC_lw, gr, "idC_lw", 1), get_base1(idC_up, gr, "idC_up", 1)), stan::model::nil_index_list()), "tconc"), 
                            "assigning variable tconc_ode");
                current_statement_begin__ = 200;
                stan::model::assign(tconc_ode, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(idC_lw, gr, "idC_lw", 1)), stan::model::nil_index_list()), 
                            (get_base1(tconc, get_base1(idC_lw, gr, "idC_lw", 1), "tconc", 1) + 1e-9), 
                            "assigning variable tconc_ode");
            }
            // validate transformed data
            current_statement_begin__ = 183;
            size_t y0_i_0_max__ = 1;
            for (size_t i_0__ = 0; i_0__ < y0_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y0[i_0__]", y0[i_0__], 0);
            }
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 206;
            num_params_r__ += 1;
            current_statement_begin__ = 208;
            validate_non_negative_index("sigma", "(2 + nDatasets)", (2 + nDatasets));
            num_params_r__ += (1 * (2 + nDatasets));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_GUTS_IT() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 206;
        if (!(context__.contains_r("beta_log10")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_log10 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_log10");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "beta_log10", "double", context__.to_vec());
        double beta_log10(0);
        beta_log10 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta_log10);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_log10: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 208;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "(2 + nDatasets)", (2 + nDatasets));
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec((2 + nDatasets)));
        std::vector<double> sigma((2 + nDatasets), double(0));
        size_t sigma_k_0_max__ = (2 + nDatasets);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            sigma[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_i_0_max__ = (2 + nDatasets);
        for (size_t i_0__ = 0; i_0__ < sigma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 206;
            local_scalar_t__ beta_log10;
            (void) beta_log10;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_log10 = in__.scalar_constrain(lp__);
            else
                beta_log10 = in__.scalar_constrain();
            current_statement_begin__ = 208;
            std::vector<local_scalar_t__> sigma;
            size_t sigma_d_0_max__ = (2 + nDatasets);
            sigma.reserve(sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_constrain(lp__));
                else
                    sigma.push_back(in__.scalar_constrain());
            }
            // transformed parameters
            current_statement_begin__ = 214;
            local_scalar_t__ kd_log10;
            (void) kd_log10;  // dummy to suppress unused var warning
            stan::math::initialize(kd_log10, DUMMY_VAR__);
            stan::math::fill(kd_log10, DUMMY_VAR__);
            stan::math::assign(kd_log10,(kdMean_log10 + (kdSD_log10 * get_base1(sigma, 1, "sigma", 1))));
            current_statement_begin__ = 215;
            local_scalar_t__ mw_log10;
            (void) mw_log10;  // dummy to suppress unused var warning
            stan::math::initialize(mw_log10, DUMMY_VAR__);
            stan::math::fill(mw_log10, DUMMY_VAR__);
            stan::math::assign(mw_log10,(mwMean_log10 + (mwSD_log10 * get_base1(sigma, 2, "sigma", 1))));
            current_statement_begin__ = 216;
            validate_non_negative_index("hb_log10", "nDatasets", nDatasets);
            std::vector<local_scalar_t__> hb_log10(nDatasets, local_scalar_t__(0));
            stan::math::initialize(hb_log10, DUMMY_VAR__);
            stan::math::fill(hb_log10, DUMMY_VAR__);
            current_statement_begin__ = 218;
            validate_non_negative_index("param", "1", 1);
            std::vector<local_scalar_t__> param(1, local_scalar_t__(0));
            stan::math::initialize(param, DUMMY_VAR__);
            stan::math::fill(param, DUMMY_VAR__);
            current_statement_begin__ = 220;
            validate_non_negative_index("y_hat", "nData_Nsurv", nData_Nsurv);
            validate_non_negative_index("y_hat", "1", 1);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> y_hat(nData_Nsurv, 1);
            stan::math::initialize(y_hat, DUMMY_VAR__);
            stan::math::fill(y_hat, DUMMY_VAR__);
            current_statement_begin__ = 221;
            validate_non_negative_index("Psurv_hat", "nData_Nsurv", nData_Nsurv);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Psurv_hat(nData_Nsurv);
            stan::math::initialize(Psurv_hat, DUMMY_VAR__);
            stan::math::fill(Psurv_hat, DUMMY_VAR__);
            current_statement_begin__ = 222;
            validate_non_negative_index("Conditional_Psurv_hat", "nData_Nsurv", nData_Nsurv);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Conditional_Psurv_hat(nData_Nsurv);
            stan::math::initialize(Conditional_Psurv_hat, DUMMY_VAR__);
            stan::math::fill(Conditional_Psurv_hat, DUMMY_VAR__);
            current_statement_begin__ = 224;
            local_scalar_t__ mw;
            (void) mw;  // dummy to suppress unused var warning
            stan::math::initialize(mw, DUMMY_VAR__);
            stan::math::fill(mw, DUMMY_VAR__);
            stan::math::assign(mw,pow(10, mw_log10));
            current_statement_begin__ = 225;
            local_scalar_t__ beta;
            (void) beta;  // dummy to suppress unused var warning
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,pow(10, beta_log10));
            // transformed parameters block statements
            current_statement_begin__ = 227;
            for (int i = 1; i <= nDatasets; ++i) {
                current_statement_begin__ = 228;
                stan::model::assign(hb_log10, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (hbMean_log10 + (hbSD_log10 * get_base1(sigma, (2 + i), "sigma", 1))), 
                            "assigning variable hb_log10");
            }
            current_statement_begin__ = 231;
            stan::model::assign(param, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        pow(10, kd_log10), 
                        "assigning variable param");
            current_statement_begin__ = 233;
            for (int gr = 1; gr <= nGroup; ++gr) {
                {
                current_statement_begin__ = 234;
                local_scalar_t__ hb(DUMMY_VAR__);
                (void) hb;  // dummy to suppress unused var warning
                stan::math::initialize(hb, DUMMY_VAR__);
                stan::math::fill(hb, DUMMY_VAR__);
                stan::math::assign(hb,pow(10, get_base1(hb_log10, get_base1(groupDataset, gr, "groupDataset", 1), "hb_log10", 1)));
                current_statement_begin__ = 236;
                stan::model::assign(y_hat, 
                            stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            stan::model::rvalue(solve_TKTD_varIT(y0, 0, stan::model::rvalue(tNsurv_ode, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "tNsurv_ode"), param, stan::model::rvalue(tconc_ode, stan::model::cons_list(stan::model::index_min_max(get_base1(idC_lw, gr, "idC_lw", 1), get_base1(idC_up, gr, "idC_up", 1)), stan::model::nil_index_list()), "tconc_ode"), stan::model::rvalue(conc, stan::model::cons_list(stan::model::index_min_max(get_base1(idC_lw, gr, "idC_lw", 1), get_base1(idC_up, gr, "idC_up", 1)), stan::model::nil_index_list()), "conc"), odeParam, pstream__), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "solve_TKTD_varIT(y0, 0, tNsurv_ode[idS_lw[gr]:idS_up[gr]], param, tconc_ode[idC_lw[gr]:idC_up[gr]], conc[idC_lw[gr]:idC_up[gr]], odeParam, pstream__)"), 
                            "assigning variable y_hat");
                current_statement_begin__ = 238;
                for (int i = get_base1(idS_lw, gr, "idS_lw", 1); i <= get_base1(idS_up, gr, "idS_up", 1); ++i) {
                    current_statement_begin__ = 240;
                    if (as_bool(logical_eq(distribution, 1))) {
                        current_statement_begin__ = 241;
                        stan::model::assign(Psurv_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::math::exp((-(hb) * get_base1(tNsurv_ode, i, "tNsurv_ode", 1))) * (1 - stan::math::exp(loglogistic_2_lcdf(max(stan::model::rvalue(y_hat, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "y_hat")), mw, beta, pstream__)))), 
                                    "assigning variable Psurv_hat");
                    }
                    current_statement_begin__ = 243;
                    if (as_bool(logical_eq(distribution, 2))) {
                        current_statement_begin__ = 244;
                        stan::model::assign(Psurv_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::math::exp((-(hb) * get_base1(tNsurv_ode, i, "tNsurv_ode", 1))) * (1 - stan::math::exp(lognormal_cdf_log(max(stan::model::rvalue(y_hat, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "y_hat")), mw, beta)))), 
                                    "assigning variable Psurv_hat");
                    }
                    current_statement_begin__ = 247;
                    stan::model::assign(Conditional_Psurv_hat, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (logical_eq(i, get_base1(idS_lw, gr, "idS_lw", 1)) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(Psurv_hat, i, "Psurv_hat", 1)) : stan::math::promote_scalar<local_scalar_t__>((get_base1(Psurv_hat, i, "Psurv_hat", 1) / get_base1(Psurv_hat, (i - 1), "Psurv_hat", 1))) ), 
                                "assigning variable Conditional_Psurv_hat");
                }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 214;
            if (stan::math::is_uninitialized(kd_log10)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: kd_log10";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable kd_log10: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 215;
            if (stan::math::is_uninitialized(mw_log10)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mw_log10";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mw_log10: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 216;
            size_t hb_log10_k_0_max__ = nDatasets;
            for (size_t k_0__ = 0; k_0__ < hb_log10_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(hb_log10[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: hb_log10" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable hb_log10: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 218;
            size_t param_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < param_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(param[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: param" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable param: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t param_i_0_max__ = 1;
            for (size_t i_0__ = 0; i_0__ < param_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "param[i_0__]", param[i_0__], 0);
            }
            current_statement_begin__ = 220;
            size_t y_hat_j_1_max__ = nData_Nsurv;
            size_t y_hat_j_2_max__ = 1;
            for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < y_hat_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(y_hat(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: y_hat" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable y_hat: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 221;
            size_t Psurv_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_1__ = 0; j_1__ < Psurv_hat_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(Psurv_hat(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Psurv_hat" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Psurv_hat: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "Psurv_hat", Psurv_hat, 0);
            check_less_or_equal(function__, "Psurv_hat", Psurv_hat, 1);
            current_statement_begin__ = 222;
            size_t Conditional_Psurv_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_1__ = 0; j_1__ < Conditional_Psurv_hat_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(Conditional_Psurv_hat(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: Conditional_Psurv_hat" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Conditional_Psurv_hat: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "Conditional_Psurv_hat", Conditional_Psurv_hat, 0);
            check_less_or_equal(function__, "Conditional_Psurv_hat", Conditional_Psurv_hat, 1);
            current_statement_begin__ = 224;
            if (stan::math::is_uninitialized(mw)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mw";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mw: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 225;
            if (stan::math::is_uninitialized(beta)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            // model body
            current_statement_begin__ = 255;
            lp_accum__.add(uniform_log(beta_log10, betaMin_log10, betaMax_log10));
            current_statement_begin__ = 257;
            lp_accum__.add(normal_log(sigma, 0, 1));
            current_statement_begin__ = 259;
            for (int gr = 1; gr <= nGroup; ++gr) {
                current_statement_begin__ = 261;
                lp_accum__.add(binomial_log(stan::model::rvalue(Nsurv, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "Nsurv"), stan::model::rvalue(Nprec, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "Nprec"), stan::model::rvalue(Conditional_Psurv_hat, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "Conditional_Psurv_hat")));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta_log10");
        names__.push_back("sigma");
        names__.push_back("kd_log10");
        names__.push_back("mw_log10");
        names__.push_back("hb_log10");
        names__.push_back("param");
        names__.push_back("y_hat");
        names__.push_back("Psurv_hat");
        names__.push_back("Conditional_Psurv_hat");
        names__.push_back("mw");
        names__.push_back("beta");
        names__.push_back("Nsurv_ppc");
        names__.push_back("Nsurv_sim");
        names__.push_back("Nsurv_sim_prec");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((2 + nDatasets));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nDatasets);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nData_Nsurv);
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nData_Nsurv);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nData_Nsurv);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nData_Nsurv);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nData_Nsurv);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nData_Nsurv);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nData_Nsurv);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_GUTS_IT_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta_log10 = in__.scalar_constrain();
        vars__.push_back(beta_log10);
        std::vector<double> sigma;
        size_t sigma_d_0_max__ = (2 + nDatasets);
        sigma.reserve(sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
            sigma.push_back(in__.scalar_constrain());
        }
        size_t sigma_k_0_max__ = (2 + nDatasets);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 214;
            double kd_log10;
            (void) kd_log10;  // dummy to suppress unused var warning
            stan::math::initialize(kd_log10, DUMMY_VAR__);
            stan::math::fill(kd_log10, DUMMY_VAR__);
            stan::math::assign(kd_log10,(kdMean_log10 + (kdSD_log10 * get_base1(sigma, 1, "sigma", 1))));
            current_statement_begin__ = 215;
            double mw_log10;
            (void) mw_log10;  // dummy to suppress unused var warning
            stan::math::initialize(mw_log10, DUMMY_VAR__);
            stan::math::fill(mw_log10, DUMMY_VAR__);
            stan::math::assign(mw_log10,(mwMean_log10 + (mwSD_log10 * get_base1(sigma, 2, "sigma", 1))));
            current_statement_begin__ = 216;
            validate_non_negative_index("hb_log10", "nDatasets", nDatasets);
            std::vector<double> hb_log10(nDatasets, double(0));
            stan::math::initialize(hb_log10, DUMMY_VAR__);
            stan::math::fill(hb_log10, DUMMY_VAR__);
            current_statement_begin__ = 218;
            validate_non_negative_index("param", "1", 1);
            std::vector<double> param(1, double(0));
            stan::math::initialize(param, DUMMY_VAR__);
            stan::math::fill(param, DUMMY_VAR__);
            current_statement_begin__ = 220;
            validate_non_negative_index("y_hat", "nData_Nsurv", nData_Nsurv);
            validate_non_negative_index("y_hat", "1", 1);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> y_hat(nData_Nsurv, 1);
            stan::math::initialize(y_hat, DUMMY_VAR__);
            stan::math::fill(y_hat, DUMMY_VAR__);
            current_statement_begin__ = 221;
            validate_non_negative_index("Psurv_hat", "nData_Nsurv", nData_Nsurv);
            Eigen::Matrix<double, Eigen::Dynamic, 1> Psurv_hat(nData_Nsurv);
            stan::math::initialize(Psurv_hat, DUMMY_VAR__);
            stan::math::fill(Psurv_hat, DUMMY_VAR__);
            current_statement_begin__ = 222;
            validate_non_negative_index("Conditional_Psurv_hat", "nData_Nsurv", nData_Nsurv);
            Eigen::Matrix<double, Eigen::Dynamic, 1> Conditional_Psurv_hat(nData_Nsurv);
            stan::math::initialize(Conditional_Psurv_hat, DUMMY_VAR__);
            stan::math::fill(Conditional_Psurv_hat, DUMMY_VAR__);
            current_statement_begin__ = 224;
            double mw;
            (void) mw;  // dummy to suppress unused var warning
            stan::math::initialize(mw, DUMMY_VAR__);
            stan::math::fill(mw, DUMMY_VAR__);
            stan::math::assign(mw,pow(10, mw_log10));
            current_statement_begin__ = 225;
            double beta;
            (void) beta;  // dummy to suppress unused var warning
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,pow(10, beta_log10));
            // do transformed parameters statements
            current_statement_begin__ = 227;
            for (int i = 1; i <= nDatasets; ++i) {
                current_statement_begin__ = 228;
                stan::model::assign(hb_log10, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (hbMean_log10 + (hbSD_log10 * get_base1(sigma, (2 + i), "sigma", 1))), 
                            "assigning variable hb_log10");
            }
            current_statement_begin__ = 231;
            stan::model::assign(param, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        pow(10, kd_log10), 
                        "assigning variable param");
            current_statement_begin__ = 233;
            for (int gr = 1; gr <= nGroup; ++gr) {
                {
                current_statement_begin__ = 234;
                local_scalar_t__ hb(DUMMY_VAR__);
                (void) hb;  // dummy to suppress unused var warning
                stan::math::initialize(hb, DUMMY_VAR__);
                stan::math::fill(hb, DUMMY_VAR__);
                stan::math::assign(hb,pow(10, get_base1(hb_log10, get_base1(groupDataset, gr, "groupDataset", 1), "hb_log10", 1)));
                current_statement_begin__ = 236;
                stan::model::assign(y_hat, 
                            stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            stan::model::rvalue(solve_TKTD_varIT(y0, 0, stan::model::rvalue(tNsurv_ode, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "tNsurv_ode"), param, stan::model::rvalue(tconc_ode, stan::model::cons_list(stan::model::index_min_max(get_base1(idC_lw, gr, "idC_lw", 1), get_base1(idC_up, gr, "idC_up", 1)), stan::model::nil_index_list()), "tconc_ode"), stan::model::rvalue(conc, stan::model::cons_list(stan::model::index_min_max(get_base1(idC_lw, gr, "idC_lw", 1), get_base1(idC_up, gr, "idC_up", 1)), stan::model::nil_index_list()), "conc"), odeParam, pstream__), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "solve_TKTD_varIT(y0, 0, tNsurv_ode[idS_lw[gr]:idS_up[gr]], param, tconc_ode[idC_lw[gr]:idC_up[gr]], conc[idC_lw[gr]:idC_up[gr]], odeParam, pstream__)"), 
                            "assigning variable y_hat");
                current_statement_begin__ = 238;
                for (int i = get_base1(idS_lw, gr, "idS_lw", 1); i <= get_base1(idS_up, gr, "idS_up", 1); ++i) {
                    current_statement_begin__ = 240;
                    if (as_bool(logical_eq(distribution, 1))) {
                        current_statement_begin__ = 241;
                        stan::model::assign(Psurv_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::math::exp((-(hb) * get_base1(tNsurv_ode, i, "tNsurv_ode", 1))) * (1 - stan::math::exp(loglogistic_2_lcdf(max(stan::model::rvalue(y_hat, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "y_hat")), mw, beta, pstream__)))), 
                                    "assigning variable Psurv_hat");
                    }
                    current_statement_begin__ = 243;
                    if (as_bool(logical_eq(distribution, 2))) {
                        current_statement_begin__ = 244;
                        stan::model::assign(Psurv_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::math::exp((-(hb) * get_base1(tNsurv_ode, i, "tNsurv_ode", 1))) * (1 - stan::math::exp(lognormal_cdf_log(max(stan::model::rvalue(y_hat, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "y_hat")), mw, beta)))), 
                                    "assigning variable Psurv_hat");
                    }
                    current_statement_begin__ = 247;
                    stan::model::assign(Conditional_Psurv_hat, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (logical_eq(i, get_base1(idS_lw, gr, "idS_lw", 1)) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(Psurv_hat, i, "Psurv_hat", 1)) : stan::math::promote_scalar<local_scalar_t__>((get_base1(Psurv_hat, i, "Psurv_hat", 1) / get_base1(Psurv_hat, (i - 1), "Psurv_hat", 1))) ), 
                                "assigning variable Conditional_Psurv_hat");
                }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 218;
            size_t param_i_0_max__ = 1;
            for (size_t i_0__ = 0; i_0__ < param_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "param[i_0__]", param[i_0__], 0);
            }
            current_statement_begin__ = 221;
            check_greater_or_equal(function__, "Psurv_hat", Psurv_hat, 0);
            check_less_or_equal(function__, "Psurv_hat", Psurv_hat, 1);
            current_statement_begin__ = 222;
            check_greater_or_equal(function__, "Conditional_Psurv_hat", Conditional_Psurv_hat, 0);
            check_less_or_equal(function__, "Conditional_Psurv_hat", Conditional_Psurv_hat, 1);
            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(kd_log10);
                vars__.push_back(mw_log10);
                size_t hb_log10_k_0_max__ = nDatasets;
                for (size_t k_0__ = 0; k_0__ < hb_log10_k_0_max__; ++k_0__) {
                    vars__.push_back(hb_log10[k_0__]);
                }
                size_t param_k_0_max__ = 1;
                for (size_t k_0__ = 0; k_0__ < param_k_0_max__; ++k_0__) {
                    vars__.push_back(param[k_0__]);
                }
                size_t y_hat_j_2_max__ = 1;
                size_t y_hat_j_1_max__ = nData_Nsurv;
                for (size_t j_2__ = 0; j_2__ < y_hat_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                        vars__.push_back(y_hat(j_1__, j_2__));
                    }
                }
                size_t Psurv_hat_j_1_max__ = nData_Nsurv;
                for (size_t j_1__ = 0; j_1__ < Psurv_hat_j_1_max__; ++j_1__) {
                    vars__.push_back(Psurv_hat(j_1__));
                }
                size_t Conditional_Psurv_hat_j_1_max__ = nData_Nsurv;
                for (size_t j_1__ = 0; j_1__ < Conditional_Psurv_hat_j_1_max__; ++j_1__) {
                    vars__.push_back(Conditional_Psurv_hat(j_1__));
                }
                vars__.push_back(mw);
                vars__.push_back(beta);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 270;
            validate_non_negative_index("Nsurv_ppc", "nData_Nsurv", nData_Nsurv);
            std::vector<int> Nsurv_ppc(nData_Nsurv, int(0));
            stan::math::fill(Nsurv_ppc, std::numeric_limits<int>::min());
            current_statement_begin__ = 271;
            validate_non_negative_index("Nsurv_sim", "nData_Nsurv", nData_Nsurv);
            std::vector<int> Nsurv_sim(nData_Nsurv, int(0));
            stan::math::fill(Nsurv_sim, std::numeric_limits<int>::min());
            current_statement_begin__ = 272;
            validate_non_negative_index("Nsurv_sim_prec", "nData_Nsurv", nData_Nsurv);
            std::vector<int> Nsurv_sim_prec(nData_Nsurv, int(0));
            stan::math::fill(Nsurv_sim_prec, std::numeric_limits<int>::min());
            current_statement_begin__ = 274;
            validate_non_negative_index("log_lik", "nData_Nsurv", nData_Nsurv);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(nData_Nsurv);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 276;
            for (int gr = 1; gr <= nGroup; ++gr) {
                current_statement_begin__ = 278;
                for (int i = get_base1(idS_lw, gr, "idS_lw", 1); i <= get_base1(idS_up, gr, "idS_up", 1); ++i) {
                    current_statement_begin__ = 279;
                    stan::model::assign(Nsurv_ppc, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                binomial_rng(get_base1(Nprec, i, "Nprec", 1), get_base1(Conditional_Psurv_hat, i, "Conditional_Psurv_hat", 1), base_rng__), 
                                "assigning variable Nsurv_ppc");
                    current_statement_begin__ = 281;
                    stan::model::assign(Nsurv_sim_prec, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (logical_eq(i, get_base1(idS_lw, gr, "idS_lw", 1)) ? get_base1(Nprec, i, "Nprec", 1) : get_base1(Nsurv_sim, (i - 1), "Nsurv_sim", 1) ), 
                                "assigning variable Nsurv_sim_prec");
                    current_statement_begin__ = 283;
                    stan::model::assign(Nsurv_sim, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                binomial_rng(get_base1(Nsurv_sim_prec, i, "Nsurv_sim_prec", 1), get_base1(Conditional_Psurv_hat, i, "Conditional_Psurv_hat", 1), base_rng__), 
                                "assigning variable Nsurv_sim");
                    current_statement_begin__ = 285;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                binomial_log(stan::model::rvalue(Nsurv, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "Nsurv"), stan::model::rvalue(Nprec, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "Nprec"), stan::model::rvalue(Conditional_Psurv_hat, stan::model::cons_list(stan::model::index_min_max(get_base1(idS_lw, gr, "idS_lw", 1), get_base1(idS_up, gr, "idS_up", 1)), stan::model::nil_index_list()), "Conditional_Psurv_hat")), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 270;
            size_t Nsurv_ppc_k_0_max__ = nData_Nsurv;
            for (size_t k_0__ = 0; k_0__ < Nsurv_ppc_k_0_max__; ++k_0__) {
                vars__.push_back(Nsurv_ppc[k_0__]);
            }
            current_statement_begin__ = 271;
            size_t Nsurv_sim_k_0_max__ = nData_Nsurv;
            for (size_t k_0__ = 0; k_0__ < Nsurv_sim_k_0_max__; ++k_0__) {
                vars__.push_back(Nsurv_sim[k_0__]);
            }
            current_statement_begin__ = 272;
            size_t Nsurv_sim_prec_k_0_max__ = nData_Nsurv;
            for (size_t k_0__ = 0; k_0__ < Nsurv_sim_prec_k_0_max__; ++k_0__) {
                vars__.push_back(Nsurv_sim_prec[k_0__]);
            }
            current_statement_begin__ = 274;
            size_t log_lik_j_1_max__ = nData_Nsurv;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_GUTS_IT";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta_log10";
        param_names__.push_back(param_name_stream__.str());
        size_t sigma_k_0_max__ = (2 + nDatasets);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kd_log10";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "mw_log10";
            param_names__.push_back(param_name_stream__.str());
            size_t hb_log10_k_0_max__ = nDatasets;
            for (size_t k_0__ = 0; k_0__ < hb_log10_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "hb_log10" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t param_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < param_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "param" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t y_hat_j_2_max__ = 1;
            size_t y_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_2__ = 0; j_2__ < y_hat_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_hat" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Psurv_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_1__ = 0; j_1__ < Psurv_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Psurv_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Conditional_Psurv_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_1__ = 0; j_1__ < Conditional_Psurv_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Conditional_Psurv_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "mw";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t Nsurv_ppc_k_0_max__ = nData_Nsurv;
        for (size_t k_0__ = 0; k_0__ < Nsurv_ppc_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Nsurv_ppc" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Nsurv_sim_k_0_max__ = nData_Nsurv;
        for (size_t k_0__ = 0; k_0__ < Nsurv_sim_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Nsurv_sim" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Nsurv_sim_prec_k_0_max__ = nData_Nsurv;
        for (size_t k_0__ = 0; k_0__ < Nsurv_sim_prec_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Nsurv_sim_prec" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = nData_Nsurv;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta_log10";
        param_names__.push_back(param_name_stream__.str());
        size_t sigma_k_0_max__ = (2 + nDatasets);
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kd_log10";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "mw_log10";
            param_names__.push_back(param_name_stream__.str());
            size_t hb_log10_k_0_max__ = nDatasets;
            for (size_t k_0__ = 0; k_0__ < hb_log10_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "hb_log10" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t param_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < param_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "param" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t y_hat_j_2_max__ = 1;
            size_t y_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_2__ = 0; j_2__ < y_hat_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_hat" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Psurv_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_1__ = 0; j_1__ < Psurv_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Psurv_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Conditional_Psurv_hat_j_1_max__ = nData_Nsurv;
            for (size_t j_1__ = 0; j_1__ < Conditional_Psurv_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Conditional_Psurv_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "mw";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t Nsurv_ppc_k_0_max__ = nData_Nsurv;
        for (size_t k_0__ = 0; k_0__ < Nsurv_ppc_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Nsurv_ppc" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Nsurv_sim_k_0_max__ = nData_Nsurv;
        for (size_t k_0__ = 0; k_0__ < Nsurv_sim_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Nsurv_sim" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Nsurv_sim_prec_k_0_max__ = nData_Nsurv;
        for (size_t k_0__ = 0; k_0__ < Nsurv_sim_prec_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Nsurv_sim_prec" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = nData_Nsurv;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_GUTS_IT_namespace::model_GUTS_IT stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
