/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution.shrinkage;

import dr.inference.distribution.shrinkage.BayesianBridgeDistributionModel;
import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.HessianWrtParameterProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.PriorPreconditioningProvider;
import dr.inference.model.Variable;

public class BayesianBridgeLikelihood
extends AbstractModelLikelihood
implements BayesianBridgeStatisticsProvider,
PriorPreconditioningProvider,
GradientWrtParameterProvider,
HessianWrtParameterProvider {
    private final Parameter coefficients;
    private final BayesianBridgeDistributionModel distribution;
    private final int dim;

    public BayesianBridgeLikelihood(Parameter parameter, BayesianBridgeDistributionModel bayesianBridgeDistributionModel) {
        super("bayesianBridge");
        this.coefficients = parameter;
        this.distribution = bayesianBridgeDistributionModel;
        this.dim = parameter.getDimension();
        this.addModel(bayesianBridgeDistributionModel);
        this.addVariable(parameter);
    }

    @Override
    public Parameter getGlobalScale() {
        return this.distribution.getGlobalScale();
    }

    @Override
    public Parameter getExponent() {
        return this.distribution.getExponent();
    }

    @Override
    public Parameter getLocalScale() {
        return this.distribution.getLocalScale();
    }

    @Override
    public Parameter getSlabWidth() {
        return this.distribution.getSlabWidth();
    }

    @Override
    public double getCoefficient(int n) {
        return this.coefficients.getParameterValue(n);
    }

    @Override
    public double getLogLikelihood() {
        return this.distribution.logPdf(this.coefficients.getParameterValues());
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.distribution.gradientLogPdf(this.coefficients.getParameterValues());
    }

    @Override
    public double[] getDiagonalHessianLogDensity() {
        return this.distribution.getDiagonalHessianLogDensity(this.coefficients.getParameterValues());
    }

    @Override
    public double[][] getHessianLogDensity() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public Parameter getParameter() {
        return this.coefficients;
    }

    @Override
    public final void makeDirty() {
    }

    @Override
    public final void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public void storeState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public double getStandardDeviation(int n) {
        if (this.distribution instanceof PriorPreconditioningProvider) {
            return ((PriorPreconditioningProvider)((Object)this.distribution)).getStandardDeviation(n);
        }
        throw new RuntimeException("Not a prior conditioner");
    }
}

