/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.CompoundSymmetricMatrix;
import dr.inference.model.Model;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import java.util.List;

public class SampledMultivariateTraitLikelihood
extends AbstractMultivariateTraitLikelihood {
    public SampledMultivariateTraitLikelihood(String string, MutableTreeModel mutableTreeModel, MultivariateDiffusionModel multivariateDiffusionModel, CompoundParameter compoundParameter, List<Integer> list, boolean bl, boolean bl2, boolean bl3, BranchRateModel branchRateModel, Model model, boolean bl4, boolean bl5) {
        super(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, null, list, bl, bl2, bl3, branchRateModel, null, null, null, model, bl4, bl5);
    }

    @Override
    protected String extraInfo() {
        return "\tSampling internal trait values: true\n";
    }

    @Override
    public double calculateLogLikelihood() {
        double d = !this.cacheBranches ? this.traitLogLikelihood(null, this.treeModel.getRoot()) : this.traitCachedLogLikelihood(null, this.treeModel.getRoot());
        if (d > this.maxLogLikelihood) {
            this.maxLogLikelihood = d;
        }
        return d;
    }

    @Override
    protected double calculateAscertainmentCorrection(int n) {
        throw new RuntimeException("Ascertainment correction not yet implemented for sampled trait likelihoods");
    }

    @Override
    public final double getLogDataLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getExternalNode(i);
            if (this.cacheBranches && this.validLogLikelihoods[nodeRef.getNumber()]) {
                d += this.cachedLogLikelihoods[nodeRef.getNumber()];
                continue;
            }
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            double[] dArray = this.treeModel.getMultivariateNodeTrait(nodeRef, this.traitName);
            double[] dArray2 = this.treeModel.getMultivariateNodeTrait(nodeRef2, this.traitName);
            double d2 = this.getRescaledBranchLengthForPrecision(nodeRef);
            d += this.diffusionModel.getLogLikelihood(dArray2, dArray, d2);
        }
        return d;
    }

    private double traitCachedLogLikelihood(double[] dArray, NodeRef nodeRef) {
        double d = 0.0;
        double[] dArray2 = null;
        int n = nodeRef.getNumber();
        if (!this.treeModel.isRoot(nodeRef)) {
            if (!this.validLogLikelihoods[n]) {
                dArray2 = this.treeModel.getMultivariateNodeTrait(nodeRef, this.traitName);
                double d2 = this.getRescaledBranchLengthForPrecision(nodeRef);
                if (dArray == null) {
                    dArray = this.treeModel.getMultivariateNodeTrait(this.treeModel.getParent(nodeRef), this.traitName);
                }
                this.cachedLogLikelihoods[n] = d = this.diffusionModel.getLogLikelihood(dArray, dArray2, d2);
                this.validLogLikelihoods[n] = true;
            } else {
                d = this.cachedLogLikelihoods[n];
            }
        }
        int n2 = this.treeModel.getChildCount(nodeRef);
        for (int i = 0; i < n2; ++i) {
            d += this.traitCachedLogLikelihood(dArray2, this.treeModel.getChild(nodeRef, i));
        }
        return d;
    }

    private double traitLogLikelihood(double[] dArray, NodeRef nodeRef) {
        double d;
        double d2 = 0.0;
        double[] dArray2 = this.treeModel.getMultivariateNodeTrait(nodeRef, this.traitName);
        if (dArray != null && new Double(d2 = this.diffusionModel.getLogLikelihood(dArray, dArray2, d = this.getRescaledBranchLengthForPrecision(nodeRef))).isNaN()) {
            System.err.println("AbstractMultivariateTraitLikelihood: likelihood is undefined");
            System.err.println("time = " + d);
            System.err.println("parent trait value = " + new Vector(dArray));
            System.err.println("child trait value = " + new Vector(dArray2));
            double[][] dArray3 = this.diffusionModel.getPrecisionmatrix();
            if (dArray3 != null) {
                System.err.println("precision matrix = " + new Matrix(this.diffusionModel.getPrecisionmatrix()));
                if (this.diffusionModel.getPrecisionParameter() instanceof CompoundSymmetricMatrix) {
                    CompoundSymmetricMatrix compoundSymmetricMatrix = (CompoundSymmetricMatrix)this.diffusionModel.getPrecisionParameter();
                }
            }
        }
        int n = this.treeModel.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            d2 += this.traitLogLikelihood(dArray2, this.treeModel.getChild(nodeRef, i));
        }
        if (new Double(d2).isNaN()) {
            System.err.println("logL = " + d2);
            System.exit(-1);
        }
        return d2;
    }

    @Override
    public double[] getTraitForNode(Tree tree, NodeRef nodeRef, String string) {
        return ((TreeModel)tree).getMultivariateNodeTrait(nodeRef, string);
    }
}

