/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.structure;

import dr.evolution.alignment.Alignment;
import dr.evolution.colouring.BasicColourSampler;
import dr.evolution.colouring.ColourSampler;
import dr.evolution.colouring.DefaultTreeColouring;
import dr.evolution.colouring.StructuredColourSampler;
import dr.evolution.colouring.TreeColouring;
import dr.evolution.colouring.TreeColouringProvider;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxa;
import dr.evolution.util.TaxonList;
import dr.evomodel.coalescent.structure.MetaPopulationModel;
import dr.evomodel.coalescent.structure.MigrationModel;
import dr.evomodel.coalescent.structure.StructuredCoalescentLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Statistic;
import dr.inference.model.StatisticList;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.logging.Logger;

@Deprecated
public class ColourSamplerModel
extends AbstractModel
implements TreeColouringProvider,
ModelListener,
StatisticList {
    public static final String COLOUR_SAMPLER_MODEL = "colourSamplerModel";
    public static final String STRUCTURED_SAMPLER = "structuredSampler";
    public static final String NODE_BIAS = "nodeBias";
    public static final String BRANCH_BIAS = "branchBias";
    public static final String SECOND_ITERATION = "secondIteration";
    private final Statistic migrationEventStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "migrationEvents";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            DefaultTreeColouring defaultTreeColouring = ColourSamplerModel.this.getTreeColouringWithProbability();
            return defaultTreeColouring.getColourChangeCount();
        }
    };
    private final Statistic rootColourStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "rootColour";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            DefaultTreeColouring defaultTreeColouring = ColourSamplerModel.this.getTreeColouringWithProbability();
            return defaultTreeColouring.getNodeColour(defaultTreeColouring.getTree().getRoot());
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new ElementRule("colours", new XMLSyntaxRule[]{new ElementRule(Taxa.class, "Taxa for each subsequent colour (after 0).", 1, Integer.MAX_VALUE)}), new ElementRule(Alignment.class, "The alignment.")), new ElementRule(TreeModel.class, "The tree."), new ElementRule(MigrationModel.class, "The migration model."), new ElementRule(MetaPopulationModel.class, "The metapopulation model,")};

        @Override
        public String getParserName() {
            return ColourSamplerModel.COLOUR_SAMPLER_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ColourSampler colourSampler;
            Object object;
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            MigrationModel migrationModel = (MigrationModel)xMLObject.getChild(MigrationModel.class);
            MetaPopulationModel metaPopulationModel = (MetaPopulationModel)xMLObject.getChild(MetaPopulationModel.class);
            boolean bl = xMLObject.getAttribute(ColourSamplerModel.STRUCTURED_SAMPLER, true);
            boolean bl2 = xMLObject.getAttribute(ColourSamplerModel.BRANCH_BIAS, true);
            boolean bl3 = xMLObject.getAttribute(ColourSamplerModel.NODE_BIAS, true);
            boolean bl4 = xMLObject.getAttribute(ColourSamplerModel.SECOND_ITERATION, false);
            if (xMLObject.hasChildNamed("colours")) {
                object = xMLObject.getChild("colours");
                TaxonList[] taxonListArray = new Taxa[((XMLObject)object).getChildCount()];
                for (int i = 0; i < ((XMLObject)object).getChildCount(); ++i) {
                    taxonListArray[i] = (Taxa)((XMLObject)object).getChild(i);
                }
                colourSampler = bl ? new StructuredColourSampler(taxonListArray, (Tree)treeModel, bl3, bl2, bl4) : new BasicColourSampler(taxonListArray, (Tree)treeModel);
            } else {
                object = (Alignment)xMLObject.getChild(Alignment.class);
                colourSampler = bl ? new StructuredColourSampler((Alignment)object, (Tree)treeModel, bl3, bl2, bl4) : new BasicColourSampler((Alignment)object, (Tree)treeModel);
            }
            object = new ColourSamplerModel(treeModel, colourSampler, migrationModel, metaPopulationModel);
            if (bl) {
                Logger.getLogger("dr.evomodel").info("Creating colour sampler model with 2 colours");
                if (!bl3) {
                    Logger.getLogger("dr.evomodel").info(" Colour sampler has node biases switched off");
                }
                if (!bl2) {
                    Logger.getLogger("dr.evomodel").info(" Colour sampler has branch biases switched off");
                }
            } else {
                Logger.getLogger("dr.evomodel").info("Creating basic 2-colour sampler");
            }
            return object;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a likelihood function for transmission.";
        }

        @Override
        public Class getReturnType() {
            return StructuredCoalescentLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final MetaPopulationModel metaPopulationModel;
    private final MigrationModel migrationModel;
    private final ColourSampler colourSampler;
    private final TreeModel treeModel;
    private DefaultTreeColouring treeColouring = null;
    private DefaultTreeColouring storedTreeColouring = null;

    public ColourSamplerModel(TreeModel treeModel, ColourSampler colourSampler, MigrationModel migrationModel, MetaPopulationModel metaPopulationModel) {
        super(COLOUR_SAMPLER_MODEL);
        this.treeModel = treeModel;
        this.addModel(treeModel);
        this.migrationModel = migrationModel;
        this.addModel(migrationModel);
        this.metaPopulationModel = metaPopulationModel;
        this.addStatistic(this.migrationEventStatistic);
        this.addStatistic(this.rootColourStatistic);
        this.colourSampler = colourSampler;
    }

    @Override
    public final TreeColouring getTreeColouring(Tree tree) {
        return this.getTreeColouring();
    }

    public final DefaultTreeColouring getTreeColouring() {
        if (this.treeColouring == null) {
            this.sample();
        }
        return this.treeColouring;
    }

    public final int[] getLeafColourCounts() {
        return this.colourSampler.getLeafColourCounts();
    }

    public final DefaultTreeColouring getTreeColouringWithProbability() {
        DefaultTreeColouring defaultTreeColouring = this.getTreeColouring();
        if (defaultTreeColouring.hasProbability()) {
            return defaultTreeColouring;
        }
        double d = this.colourSampler.getProposalProbability(defaultTreeColouring, this.treeModel, this.migrationModel.getMigrationMatrix(), this.metaPopulationModel);
        defaultTreeColouring.setLogProbabilityDensity(d);
        return defaultTreeColouring;
    }

    public final void resample() {
        this.treeColouring = null;
    }

    public final void invalidateProposalProbability() {
        this.treeColouring = new DefaultTreeColouring(this.treeColouring);
    }

    private void sample() {
        this.treeColouring = this.colourSampler.sampleTreeColouring(this.treeModel, this.migrationModel.getMigrationMatrix(), this.metaPopulationModel);
        this.listenerHelper.fireModelChanged(this);
    }

    @Override
    public void storeState() {
        this.storedTreeColouring = this.treeColouring;
    }

    @Override
    public void restoreState() {
        this.treeColouring = this.storedTreeColouring;
    }

    @Override
    public void acceptState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.resample();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

