/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evolution.tree.Tree;
import dr.evomodel.alloppnet.speciation.MulSpeciesBindings;
import dr.evomodel.alloppnet.speciation.MulSpeciesTreeModel;
import dr.inference.model.Parameter;
import dr.inference.model.ParameterParser;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MulSpeciesTreeModelParser
extends AbstractXMLObjectParser {
    public static final String MUL_SPECIES_TREE = "mulSpeciesTree";
    public static final String SPP_SPLIT_POPULATIONS = "sppSplitPopulations";
    public static final String CONST_ROOT_POPULATION = "constantRoot";
    public static final String CONSTANT_POPULATION = "constantPopulation";

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        MulSpeciesBindings mulSpeciesBindings = (MulSpeciesBindings)xMLObject.getChild(MulSpeciesBindings.class);
        Boolean bl = xMLObject.getAttribute(CONST_ROOT_POPULATION, false);
        Boolean bl2 = xMLObject.getAttribute(CONSTANT_POPULATION, false);
        XMLObject xMLObject2 = xMLObject.getChild(SPP_SPLIT_POPULATIONS);
        double d = xMLObject2.getAttribute("value", 1.0);
        boolean bl3 = bl == false;
        Parameter parameter = MulSpeciesTreeModel.createSplitPopulationsParameter(mulSpeciesBindings, d, bl3, bl2);
        ParameterParser.replaceParameter(xMLObject2, parameter);
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, parameter.getDimension());
        parameter.addBounds(defaultBounds);
        Tree tree = null;
        return new MulSpeciesTreeModel(mulSpeciesBindings, parameter, null, null, tree, false, bl3, bl2);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newBooleanRule(CONST_ROOT_POPULATION, true), AttributeRule.newBooleanRule(CONSTANT_POPULATION, true), new ElementRule(MulSpeciesBindings.class), new ElementRule(Tree.class, true), new ElementRule(SPP_SPLIT_POPULATIONS, new XMLSyntaxRule[]{AttributeRule.newDoubleRule("value", true), new ElementRule(Parameter.class)})};
    }

    @Override
    public String getParserDescription() {
        return "Multiply-labelled species tree which includes demographic function per branch.";
    }

    @Override
    public Class getReturnType() {
        return MulSpeciesTreeModel.class;
    }

    @Override
    public String getParserName() {
        return MUL_SPECIES_TREE;
    }
}

