/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.DataType;
import dr.util.Citable;

public interface EmpiricalRateMatrix
extends Citable {
    public String getName();

    public DataType getDataType();

    public double[] getEmpiricalRates();

    public double[] getEmpiricalFrequencies();

    public static abstract class AbstractAminoAcid
    extends Abstract {
        public AbstractAminoAcid(String string) {
            super(string, AminoAcids.INSTANCE);
            int n = this.dataType.getStateCount();
            this.rates = new double[n * (n - 1) / 2];
            this.frequencies = new double[n];
        }

        public final void setEmpiricalRates(double[][] dArray, String string) {
            int n = 0;
            for (int i = 0; i < this.dataType.getStateCount(); ++i) {
                int n2 = string.indexOf(this.dataType.getChar(i));
                for (int j = i + 1; j < this.dataType.getStateCount(); ++j) {
                    int n3 = string.indexOf(this.dataType.getChar(j));
                    this.rates[n] = n2 < n3 ? dArray[n2][n3] : dArray[n3][n2];
                    ++n;
                }
            }
        }

        public final void setEmpiricalFrequencies(double[] dArray, String string) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.dataType.getStateCount(); ++n) {
                int n2 = string.indexOf(this.dataType.getChar(n));
                this.frequencies[n] = dArray[n2];
                d += this.frequencies[n];
            }
            n = 0;
            while (n < this.dataType.getStateCount()) {
                int n3 = n++;
                this.frequencies[n3] = this.frequencies[n3] / d;
            }
        }
    }

    public static abstract class Abstract
    implements EmpiricalRateMatrix {
        protected double[] rates = null;
        protected double[] frequencies = null;
        private String name;
        protected DataType dataType;

        public Abstract(String string, DataType dataType) {
            this.name = string;
            this.dataType = dataType;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final DataType getDataType() {
            return this.dataType;
        }

        @Override
        public final double[] getEmpiricalRates() {
            return this.rates;
        }

        @Override
        public final double[] getEmpiricalFrequencies() {
            return this.frequencies;
        }
    }
}

