/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.app.gui.ColorFunction;
import dr.geo.KMLRenderer;
import dr.geo.Lattice;
import dr.geo.Location;
import dr.geo.RateMatrix;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class InhomogeneousRandomWalk
extends JComponent {
    Lattice lattice;
    RateMatrix rates;
    int i;
    int j;
    Random random;
    double time;
    int[][] sample;
    int maxSample = 0;
    ColorFunction cf = new ColorFunction(new Color[]{Color.white, Color.blue, Color.magenta, Color.red}, new float[]{0.0f, 0.1f, 0.2f, 1.0f});

    public InhomogeneousRandomWalk(Lattice lattice, Location location, Random random, RateMatrix rateMatrix) {
        this.lattice = lattice;
        this.rates = rateMatrix;
        this.i = location.i;
        this.j = location.j;
        this.random = random;
        this.sample = new int[lattice.latticeWidth()][lattice.latticeHeight()];
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.lattice.latticeWidth(), this.lattice.latticeHeight());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.lattice.paintLattice(graphics);
        for (int i = 0; i < this.lattice.latticeWidth(); ++i) {
            for (int j = 0; j < this.lattice.latticeHeight(); ++j) {
                if (this.sample[i][j] <= 0 || this.lattice.getState(i, j) < 0) continue;
                float f = (float)this.sample[i][j] / (float)this.maxSample;
                graphics.setColor(this.cf.getColor(f));
                graphics.drawRect(i, j, 1, 1);
            }
        }
    }

    public double computeP(Location location, Location location2, double d, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.simulate(location, d);
            if (this.i != location2.i || this.j != location2.j) continue;
            ++n2;
        }
        return (double)n2 / (double)n;
    }

    public void simulate(Location location, double d) {
        this.i = location.i;
        this.j = location.j;
        this.time = 0.0;
        while (this.time < d) {
            this.step(d);
        }
    }

    public void simulate(int n) {
        for (int i = 0; i < n; ++i) {
            this.step(Double.MAX_VALUE);
        }
    }

    public void step(double d) {
        int n = this.lattice.getState(this.i, this.j);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (this.i > 0) {
            d3 = this.rates.getRate(n, this.lattice.getState(this.i - 1, this.j));
        }
        if (this.i < this.lattice.latticeWidth() - 1) {
            d4 = this.rates.getRate(n, this.lattice.getState(this.i + 1, this.j));
        }
        if (this.j > 0) {
            d2 = this.rates.getRate(n, this.lattice.getState(this.i, this.j - 1));
        }
        if (this.j < this.lattice.latticeHeight() - 1) {
            d5 = this.rates.getRate(n, this.lattice.getState(this.i, this.j + 1));
        }
        double d6 = d2 + d5 + d3 + d4;
        double d7 = this.random.nextDouble();
        double d8 = -Math.log(d7) / d6;
        if (this.time + d8 > d) {
            this.time = d;
            return;
        }
        double d9 = this.random.nextDouble() * d6;
        if (!(d9 < d2)) {
            if ((d9 -= d2) < d4) {
                ++this.i;
            } else if ((d9 -= d4) < d5) {
                ++this.j;
            } else {
                --this.i;
            }
        }
        this.time += d8;
        int[] nArray = this.sample[this.i];
        int n2 = --this.j;
        nArray[n2] = nArray[n2] + 1;
        if (this.sample[this.i][this.j] > this.maxSample) {
            this.maxSample = this.sample[this.i][this.j];
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        double d3 = Double.parseDouble(stringArray[3]);
        double d4 = Double.parseDouble(stringArray[4]);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        Random random = new Random();
        final double[][] dArray = new double[2][2];
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        dArray[1][0] = 0.0;
        dArray[1][1] = 2.0;
        KMLRenderer kMLRenderer = new KMLRenderer(string, Color.white, Color.black);
        kMLRenderer.setBounds(double_);
        kMLRenderer.render(1000);
        RateMatrix rateMatrix = new RateMatrix(){

            @Override
            public double getRate(int n, int n2) {
                return dArray[n][n2];
            }
        };
        InhomogeneousRandomWalk inhomogeneousRandomWalk = new InhomogeneousRandomWalk(kMLRenderer, new Location(0, 0), random, rateMatrix);
        for (int i = 0; i < 5; ++i) {
            Location location = Lattice.Utils.getRandomLocation(kMLRenderer, 1, random);
            for (int j = 0; j < 1000; ++j) {
                inhomogeneousRandomWalk.simulate(location, 4000.0);
            }
        }
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add("Center", inhomogeneousRandomWalk);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

