/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.distance.DistanceMatrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class MultiLociDistanceParser
extends AbstractXMLObjectParser {
    public static final String MULTI_LOCI_DISTANCE = "multiLociDistance";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(DistanceMatrix.class, 1, Integer.MAX_VALUE)};

    @Override
    public String getParserName() {
        return MULTI_LOCI_DISTANCE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n = xMLObject.getChildCount();
        ArrayList<DistanceMatrix> arrayList = new ArrayList<DistanceMatrix>();
        for (int i = 0; i < n; ++i) {
            arrayList.add((DistanceMatrix)xMLObject.getChild(i));
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = ((DistanceMatrix)arrayList.get(i)).getMeanDistance();
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        double d2 = d / (double)n;
        this.printMeans(arrayList, d2);
        return d2;
    }

    public void printMeans(ArrayList<DistanceMatrix> arrayList, double d) {
        System.out.println("Individual mean distances:");
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.print(arrayList.get(i).getId() + ": ");
            System.out.println(arrayList.get(i).getMeanDistance());
        }
        System.out.println("overallMean: " + d);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "Constructs a distance matrix from a pattern list or alignment";
    }

    @Override
    public Class getReturnType() {
        return Double.class;
    }
}

