/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.alignment.PatternList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.substmodel.GeneralSubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treelikelihood.AncestralStateTraitProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.ComparableDouble;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StructuredCoalescentLikelihood
extends AbstractModelLikelihood
implements Units,
Citable,
AncestralStateTraitProvider,
TreeTraitProvider {
    private static final boolean DEBUG = false;
    private static final boolean MATRIX_DEBUG = false;
    private static final boolean UPDATE_DEBUG = false;
    private static final boolean ASSOC_MULTIPLICATION = true;
    protected TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();
    public static Citation CITATION = new Citation(new Author[]{new Author("Nicola", "De Maio"), new Author("Chieh-Hsi", "Wu"), new Author("Kathleen", "O'Reilly"), new Author("Daniel", "Wilson")}, "New routes to phylogeography: a Bayesian structured coalescent approximation", 2015, "PLOS Genetics", 11, "e1005421", "10.1371/journal.pgen.1005421");
    protected double logLikelihood;
    protected double storedLogLikelihood;
    protected boolean likelihoodKnown = false;
    protected boolean storedLikelihoodKnown = false;
    private TreeModel treeModel;
    private BranchRateModel branchRateModel;
    private Parameter popSizes;
    private PatternList patternList;
    private final DataType dataType;
    private boolean useMAP;
    private int[][] reconstructedStates;
    private int[][] storedReconstructedStates;
    protected boolean areStatesRedrawn = false;
    protected boolean storedAreStatesRedrawn = false;
    private double[] startExpected;
    private double[] endExpected;
    private ProbDist[] nodeProbDist;
    private ArrayList<ComparableDouble> times;
    private ArrayList<Integer> children;
    private ArrayList<NodeRef> nodes;
    private int[] indices;
    private ArrayList<ComparableDouble> storedTimes;
    private ArrayList<Integer> storedChildren;
    private ArrayList<NodeRef> storedNodes;
    private int[] storedIndices;
    private ProbDist[] activeLineageList;
    private boolean[] addedLineages;
    private int addedLength;
    private GeneralSubstitutionModel generalSubstitutionModel;
    private int demes;
    private int maxCoalescentIntervals;
    private int currentCoalescentInterval;
    private double[][] migrationMatrices;
    private int finalCoalescentInterval;
    private double[][] storedMigrationMatrices;
    private boolean matricesKnown;
    private boolean rateChanged;
    private boolean treeModelUpdateFired;

    public StructuredCoalescentLikelihood(Tree tree, BranchRateModel branchRateModel, Parameter parameter, PatternList patternList, final DataType dataType, final String string, GeneralSubstitutionModel generalSubstitutionModel, int n, TaxonList taxonList, List<TaxonList> list, boolean bl) throws TreeUtils.MissingTaxonException {
        super("structuredCoalescent");
        int n2;
        this.treeModel = (TreeModel)tree;
        this.patternList = patternList;
        this.dataType = dataType;
        this.useMAP = bl;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.popSizes = parameter;
        this.addVariable(this.popSizes);
        this.branchRateModel = branchRateModel != null ? branchRateModel : new DefaultBranchRateModel();
        this.addModel(this.branchRateModel);
        this.generalSubstitutionModel = generalSubstitutionModel;
        this.addModel(this.generalSubstitutionModel);
        this.demes = generalSubstitutionModel.getDataType().getStateCount();
        this.startExpected = new double[this.demes];
        this.endExpected = new double[this.demes];
        int n3 = this.treeModel.getNodeCount();
        this.activeLineageList = new ProbDist[n3];
        this.addedLineages = new boolean[n3];
        for (n2 = 0; n2 < this.addedLineages.length; ++n2) {
            this.addedLineages[n2] = false;
        }
        this.addedLength = 0;
        this.nodeProbDist = new ProbDist[n3];
        for (n2 = 0; n2 < this.nodeProbDist.length; ++n2) {
            this.nodeProbDist[n2] = new ProbDist(this.demes);
        }
        for (n2 = 0; n2 < this.treeModel.getExternalNodeCount(); ++n2) {
            NodeRef nodeRef = this.treeModel.getExternalNode(n2);
            this.nodeProbDist[nodeRef.getNumber()].patternIndex = patternList.getPattern(0)[patternList.getTaxonIndex(this.treeModel.getNodeTaxon(nodeRef).getId())];
            this.nodeProbDist[nodeRef.getNumber()].node = nodeRef;
            this.nodeProbDist[nodeRef.getNumber()].intervalType = IntervalType.SAMPLE;
            this.nodeProbDist[nodeRef.getNumber()].leftChild = null;
            this.nodeProbDist[nodeRef.getNumber()].rightChild = null;
        }
        this.maxCoalescentIntervals = this.treeModel.getTaxonCount() * 2 - 2;
        this.currentCoalescentInterval = 0;
        this.migrationMatrices = new double[this.maxCoalescentIntervals][this.demes * this.demes];
        this.storedMigrationMatrices = new double[this.maxCoalescentIntervals][this.demes * this.demes];
        this.times = new ArrayList();
        this.children = new ArrayList();
        this.nodes = new ArrayList();
        this.storedTimes = new ArrayList();
        this.storedChildren = new ArrayList();
        this.storedNodes = new ArrayList();
        this.treeModelUpdateFired = false;
        this.rateChanged = false;
        this.likelihoodKnown = false;
        this.reconstructedStates = new int[this.treeModel.getNodeCount()][patternList.getPatternCount()];
        this.storedReconstructedStates = new int[this.treeModel.getNodeCount()][patternList.getPatternCount()];
        this.treeTraits.addTrait(new TreeTrait.IA(){

            @Override
            public String getTraitName() {
                return string;
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.NODE;
            }

            @Override
            public Class getTraitClass() {
                return int[].class;
            }

            @Override
            public int[] getTrait(Tree tree, NodeRef nodeRef) {
                return StructuredCoalescentLikelihood.this.getStatesForNode(tree, nodeRef);
            }

            @Override
            public String getTraitString(Tree tree, NodeRef nodeRef) {
                return StructuredCoalescentLikelihood.formattedState(StructuredCoalescentLikelihood.this.getStatesForNode(tree, nodeRef), dataType);
            }
        });
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public double calculateLogLikelihood() {
        this.areStatesRedrawn = false;
        this.logLikelihood = this.traverseTree(this.treeModel, this.treeModel.getRoot(), this.patternList);
        this.redrawAncestralStates();
        return this.logLikelihood;
    }

    private double traverseTree(Tree tree, NodeRef nodeRef, PatternList patternList) {
        double d = 1.0E-9;
        if (this.treeModelUpdateFired && !this.rateChanged) {
            this.updateTransitionProbabilities();
            this.treeModelUpdateFired = false;
        } else {
            this.times.clear();
            this.children.clear();
            this.nodes.clear();
            this.collectAllTimes(tree, nodeRef, this.nodes, this.times, this.children);
            this.indices = new int[this.times.size()];
            HeapSort.sort(this.times, this.indices);
        }
        double d2 = 0.0;
        double d3 = this.times.get(this.indices[0]).doubleValue();
        int n = 0;
        int n2 = 0;
        while (n < this.times.size()) {
            NodeRef nodeRef2;
            NodeRef nodeRef3;
            int n3;
            double d4;
            int n4 = 0;
            int n5 = 0;
            double d5 = d4 = this.times.get(this.indices[n]).doubleValue();
            double d6 = d4 - d3;
            while (Math.abs(d5 - d4) < d) {
                n3 = this.children.get(this.indices[n]);
                if (n3 == 0) {
                    ++n5;
                } else {
                    n4 += n3 - 1;
                }
                if (++n == this.times.size()) break;
                d5 = this.times.get(this.indices[n]).doubleValue();
            }
            if (n5 > 0) {
                if (d6 > d) {
                    this.incrementActiveLineages(d4 - d3);
                    while (Math.abs(this.treeModel.getNodeHeight(this.nodes.get(this.indices[n2])) - d4) < d) {
                        NodeRef nodeRef4 = this.nodes.get(this.indices[n2]);
                        if (this.treeModel.isExternal(nodeRef4)) {
                            this.nodeProbDist[nodeRef4.getNumber()].update(0.0);
                            this.addedLineages[nodeRef4.getNumber()] = true;
                        } else {
                            if (this.treeModel.getChildCount(nodeRef4) > 2) {
                                throw new RuntimeException("Structured coalescent currently only allows strictly bifurcating trees.");
                            }
                            nodeRef3 = this.treeModel.getChild(nodeRef4, 0);
                            nodeRef2 = this.treeModel.getChild(nodeRef4, 1);
                            this.nodeProbDist[nodeRef4.getNumber()].update(d6, nodeRef4, IntervalType.COALESCENT, nodeRef3, nodeRef2);
                            this.addedLineages[nodeRef4.getNumber()] = true;
                        }
                        if (++n2 < this.indices.length) continue;
                        n2 = 0;
                        break;
                    }
                } else {
                    while (Math.abs(this.treeModel.getNodeHeight(this.nodes.get(this.indices[n2])) - d3) < d) {
                        NodeRef nodeRef5 = this.nodes.get(this.indices[n2]);
                        if (!this.treeModel.isExternal(nodeRef5)) {
                            throw new RuntimeException("First interval cannot be a coalescent event.");
                        }
                        this.nodeProbDist[nodeRef5.getNumber()].update(0.0);
                        this.addedLineages[nodeRef5.getNumber()] = true;
                        if (++n2 < this.indices.length) continue;
                        n2 = 0;
                        break;
                    }
                }
                d3 = d4;
            }
            if (n4 > 0) {
                this.incrementActiveLineages(d4 - d3);
                while (Math.abs(this.treeModel.getNodeHeight(this.nodes.get(this.indices[n2])) - d4) < d) {
                    NodeRef nodeRef6 = this.nodes.get(this.indices[n2]);
                    if (this.treeModel.isExternal(nodeRef6)) {
                        this.nodeProbDist[nodeRef6.getNumber()].update(0.0);
                        this.addedLineages[nodeRef6.getNumber()] = true;
                    } else {
                        if (this.treeModel.getChildCount(nodeRef6) > 2) {
                            throw new RuntimeException("Structured coalescent currently only allows strictly bifurcating trees.");
                        }
                        nodeRef3 = this.treeModel.getChild(nodeRef6, 0);
                        nodeRef2 = this.treeModel.getChild(nodeRef6, 1);
                        ProbDist probDist = this.nodeProbDist[nodeRef3.getNumber()];
                        ProbDist probDist2 = this.nodeProbDist[nodeRef2.getNumber()];
                        this.addedLineages[nodeRef3.getNumber()] = false;
                        this.addedLineages[nodeRef2.getNumber()] = false;
                        this.nodeProbDist[nodeRef6.getNumber()].update(d6, nodeRef6, IntervalType.COALESCENT, nodeRef3, nodeRef2);
                        d2 += this.nodeProbDist[nodeRef6.getNumber()].computeCoalescedLineage(probDist, probDist2);
                        if (!this.treeModel.isRoot(nodeRef6)) {
                            this.addedLineages[nodeRef6.getNumber()] = true;
                        }
                    }
                    if (++n2 < this.indices.length) continue;
                    break;
                }
                d3 = d4;
            }
            if (d4 != 0.0) {
                d2 += this.computeLogLikelihood(d6);
            }
            this.addedLength = 0;
            for (n3 = 0; n3 < this.addedLineages.length; ++n3) {
                if (!this.addedLineages[n3]) continue;
                this.activeLineageList[this.addedLength] = this.nodeProbDist[n3];
                ++this.addedLength;
            }
        }
        this.finalCoalescentInterval = this.currentCoalescentInterval;
        this.currentCoalescentInterval = 0;
        this.matricesKnown = true;
        this.rateChanged = false;
        return d2;
    }

    private double computeLogLikelihood(double d) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[this.demes];
        double[] dArray2 = new double[this.demes];
        for (n = 0; n < this.demes; ++n) {
            this.startExpected[n] = 0.0;
            this.endExpected[n] = 0.0;
        }
        for (n = 0; n < this.addedLength; ++n) {
            ProbDist probDist = this.activeLineageList[n];
            for (int i = 0; i < this.demes; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + probDist.startLineageProbs[i] * probDist.startLineageProbs[i];
                int n3 = i;
                dArray2[n3] = dArray2[n3] + probDist.endLineageProbs[i] * probDist.endLineageProbs[i];
                int n4 = i;
                this.startExpected[n4] = this.startExpected[n4] + probDist.startLineageProbs[i];
                int n5 = i;
                this.endExpected[n5] = this.endExpected[n5] + probDist.endLineageProbs[i];
            }
        }
        for (n = 0; n < this.demes; ++n) {
            d2 += (this.startExpected[n] * this.startExpected[n] - dArray[n]) / this.popSizes.getParameterValue(n);
            d3 += (this.endExpected[n] * this.endExpected[n] - dArray2[n]) / this.popSizes.getParameterValue(n);
        }
        return (d2 *= -d / 4.0) + (d3 *= -d / 4.0);
    }

    private void computeExpectedLineageCounts() {
        int n;
        for (n = 0; n < this.demes; ++n) {
            this.startExpected[n] = 0.0;
            this.endExpected[n] = 0.0;
        }
        for (n = 0; n < this.addedLength; ++n) {
            ProbDist probDist = this.activeLineageList[n];
            double[] dArray = probDist.startLineageProbs;
            double[] dArray2 = probDist.endLineageProbs;
            for (int i = 0; i < this.demes; ++i) {
                int n2 = i;
                this.startExpected[n2] = this.startExpected[n2] + dArray[i];
                int n3 = i;
                this.endExpected[n3] = this.endExpected[n3] + dArray2[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementActiveLineages(double d) {
        double d2;
        BranchRateModel branchRateModel = this.branchRateModel;
        synchronized (branchRateModel) {
            d2 = this.branchRateModel.getBranchRate(this.treeModel, this.treeModel.getRoot());
        }
        if (!this.matricesKnown) {
            this.generalSubstitutionModel.getTransitionProbabilities(d2 * d, this.migrationMatrices[this.currentCoalescentInterval]);
        }
        for (int i = 0; i < this.addedLength; ++i) {
            this.activeLineageList[i].incrementIntervalLength(d, this.migrationMatrices[this.currentCoalescentInterval]);
        }
        ++this.currentCoalescentInterval;
    }

    private void collectAllTimes(Tree tree, NodeRef nodeRef, ArrayList<NodeRef> arrayList, ArrayList<ComparableDouble> arrayList2, ArrayList<Integer> arrayList3) {
        arrayList2.add(new ComparableDouble(tree.getNodeHeight(nodeRef)));
        arrayList.add(nodeRef);
        arrayList3.add(tree.getChildCount(nodeRef));
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            this.collectAllTimes(tree, nodeRef2, arrayList, arrayList2, arrayList3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransitionProbabilities() {
        double d;
        double[] dArray = new double[this.times.size() - 1];
        for (int i = 1; i < this.times.size(); ++i) {
            dArray[i - 1] = this.times.get(this.indices[i]).doubleValue() - this.times.get(this.indices[i - 1]).doubleValue();
        }
        this.storedTimes.clear();
        this.storedNodes.clear();
        this.storedChildren.clear();
        this.collectAllTimes(this.treeModel, this.treeModel.getRoot(), this.storedNodes, this.storedTimes, this.storedChildren);
        this.storedIndices = new int[this.storedTimes.size()];
        HeapSort.sort(this.storedTimes, this.storedIndices);
        double[] dArray2 = new double[this.storedTimes.size() - 1];
        for (int i = 1; i < this.storedTimes.size(); ++i) {
            dArray2[i - 1] = this.storedTimes.get(this.storedIndices[i]).doubleValue() - this.storedTimes.get(this.storedIndices[i - 1]).doubleValue();
        }
        BranchRateModel branchRateModel = this.branchRateModel;
        synchronized (branchRateModel) {
            d = this.branchRateModel.getBranchRate(this.treeModel, this.treeModel.getRoot());
        }
        int n = 0;
        if (dArray.length == dArray2.length) {
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] != dArray2[i] && dArray2[i] != 0.0) {
                    this.generalSubstitutionModel.getTransitionProbabilities(d * dArray2[i], this.migrationMatrices[n]);
                    ++n;
                    continue;
                }
                if (dArray2[i] == 0.0) continue;
                ++n;
            }
        } else {
            throw new RuntimeException("Number of coalescent intervals has increased?");
        }
        this.times = this.storedTimes;
        this.nodes = this.storedNodes;
        this.children = this.storedChildren;
        this.indices = this.storedIndices;
        this.matricesKnown = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            this.likelihoodKnown = false;
            this.matricesKnown = false;
            this.treeModelUpdateFired = true;
            this.areStatesRedrawn = false;
        } else if (model == this.branchRateModel) {
            this.matricesKnown = false;
            this.rateChanged = true;
            this.likelihoodKnown = false;
            this.areStatesRedrawn = false;
        } else if (model == this.generalSubstitutionModel) {
            this.matricesKnown = false;
            this.rateChanged = true;
            this.likelihoodKnown = false;
            this.areStatesRedrawn = false;
        } else {
            throw new RuntimeException("Unknown handleModelChangedEvent source, exiting.");
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
        this.areStatesRedrawn = false;
        this.matricesKnown = true;
    }

    @Override
    protected void storeState() {
        int n;
        for (n = 0; n < this.finalCoalescentInterval; ++n) {
            System.arraycopy(this.migrationMatrices[n], 0, this.storedMigrationMatrices[n], 0, this.demes * this.demes);
        }
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        if (this.areStatesRedrawn) {
            for (n = 0; n < this.reconstructedStates.length; ++n) {
                System.arraycopy(this.reconstructedStates[n], 0, this.storedReconstructedStates[n], 0, this.reconstructedStates[n].length);
            }
        }
        this.storedAreStatesRedrawn = this.areStatesRedrawn;
    }

    @Override
    protected void restoreState() {
        for (int i = 0; i < this.finalCoalescentInterval; ++i) {
            double[] dArray = this.migrationMatrices[i];
            this.migrationMatrices[i] = this.storedMigrationMatrices[i];
            this.storedMigrationMatrices[i] = dArray;
        }
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        int[][] nArray = this.reconstructedStates;
        this.reconstructedStates = this.storedReconstructedStates;
        this.storedReconstructedStates = nArray;
        this.areStatesRedrawn = this.storedAreStatesRedrawn;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.matricesKnown = false;
        this.areStatesRedrawn = false;
    }

    protected void updateAllDensities() {
        for (ProbDist probDist : this.nodeProbDist) {
            probDist.needsUpdate = true;
        }
        this.likelihoodKnown = false;
    }

    public void redrawAncestralStates() {
        this.traverseSample(this.treeModel, this.treeModel.getRoot());
        this.areStatesRedrawn = true;
    }

    public void traverseSample(TreeModel treeModel, NodeRef nodeRef) {
        NodeRef nodeRef2;
        int n;
        Object object;
        if (!treeModel.isExternal(nodeRef)) {
            object = this.nodeProbDist[nodeRef.getNumber()].startLineageProbs;
            for (n = 0; n < this.patternList.getPatternCount(); ++n) {
                this.reconstructedStates[nodeRef.getNumber()][n] = this.drawChoice((double[])object);
            }
        } else {
            object = this.nodeProbDist[nodeRef.getNumber()].endLineageProbs;
            for (n = 0; n < this.patternList.getPatternCount(); ++n) {
                this.reconstructedStates[nodeRef.getNumber()][n] = this.drawChoice((double[])object);
            }
        }
        if ((object = (Object)treeModel.getChild(nodeRef, 0)) != null) {
            this.traverseSample(treeModel, (NodeRef)object);
        }
        if ((nodeRef2 = treeModel.getChild(nodeRef, 1)) != null) {
            this.traverseSample(treeModel, nodeRef2);
        }
    }

    private int drawChoice(double[] dArray) {
        if (this.useMAP) {
            double d = dArray[0];
            int n = 0;
            for (int i = 1; i < dArray.length; ++i) {
                if (!(dArray[i] > d)) continue;
                d = dArray[i];
                n = i;
            }
            return n;
        }
        return MathUtils.randomChoicePDF(dArray);
    }

    @Override
    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.treeTraits.getTreeTrait(string);
    }

    @Override
    public String formattedState(int[] nArray) {
        return StructuredCoalescentLikelihood.formattedState(nArray, this.dataType);
    }

    private static String formattedState(int[] nArray, DataType dataType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        if (dataType instanceof GeneralDataType) {
            boolean bl = true;
            for (int n : nArray) {
                if (!bl) {
                    stringBuffer.append(" ");
                } else {
                    bl = false;
                }
                stringBuffer.append(dataType.getCode(n));
            }
        } else {
            throw new RuntimeException("Only GeneralDataType currently accepted.");
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public int[] getStatesForNode(Tree tree, NodeRef nodeRef) {
        if (tree != this.treeModel) {
            throw new RuntimeException("Can only reconstruct states on treeModel given to constructor");
        }
        if (!this.likelihoodKnown) {
            this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        if (!this.areStatesRedrawn) {
            this.redrawAncestralStates();
        }
        return this.reconstructedStates[nodeRef.getNumber()];
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    public static double rdot(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        double d = 0.0;
        if (n3 == 1 && n5 == 1 && n2 == 0 && n4 == 0) {
            for (int i = 0; i < n; ++i) {
                d += dArray[i] * dArray2[i];
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            int n8 = n4;
            while (n6 < n) {
                d += dArray[n7] * dArray2[n8];
                ++n6;
                n7 += n3;
                n8 += n5;
            }
        }
        return d;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.treeModel.setUnits(type);
    }

    @Override
    public final Units.Type getUnits() {
        return this.treeModel.getUnits();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Bayesian structured coalescent approximation";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    private class ProbDist {
        private double[] startLineageProbs;
        private double[] endLineageProbs;
        private double intervalLength;
        private NodeRef node;
        private int patternIndex;
        private boolean incremented = false;
        private boolean needsUpdate = true;
        private IntervalType intervalType;
        private NodeRef leftChild = null;
        private NodeRef rightChild = null;

        public ProbDist(int n) {
            this.startLineageProbs = new double[n];
            this.endLineageProbs = new double[n];
        }

        public ProbDist(int n, double d, NodeRef nodeRef) {
            this.startLineageProbs = new double[n];
            this.endLineageProbs = new double[n];
            this.intervalLength = d;
            this.node = nodeRef;
        }

        public ProbDist(int n, double d, NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
            this.startLineageProbs = new double[n];
            this.endLineageProbs = new double[n];
            this.intervalLength = d;
            this.node = nodeRef;
            this.leftChild = nodeRef2;
            this.rightChild = nodeRef3;
        }

        public void update(double d) {
            this.intervalLength = d;
            for (int i = 0; i < this.startLineageProbs.length; ++i) {
                this.startLineageProbs[i] = 0.0;
                this.endLineageProbs[i] = 0.0;
            }
            this.startLineageProbs[this.patternIndex] = 1.0;
            this.endLineageProbs[this.patternIndex] = 1.0;
        }

        public void update(double d, NodeRef nodeRef, IntervalType intervalType, NodeRef nodeRef2, NodeRef nodeRef3) {
            this.intervalLength = d;
            this.node = nodeRef;
            this.intervalType = intervalType;
            this.leftChild = nodeRef2;
            this.rightChild = nodeRef3;
            this.incremented = false;
            for (int i = 0; i < this.startLineageProbs.length; ++i) {
                this.startLineageProbs[i] = 0.0;
                this.endLineageProbs[i] = 0.0;
            }
            this.startLineageProbs[this.patternIndex] = 1.0;
            this.endLineageProbs[this.patternIndex] = 1.0;
        }

        public double computeCoalescedLineage(ProbDist probDist, ProbDist probDist2) {
            int n;
            double d = 0.0;
            double[] dArray = new double[StructuredCoalescentLikelihood.this.demes];
            for (n = 0; n < StructuredCoalescentLikelihood.this.demes; ++n) {
                dArray[n] = probDist.endLineageProbs[n] * probDist2.endLineageProbs[n] / StructuredCoalescentLikelihood.this.popSizes.getParameterValue(n);
                d += dArray[n];
            }
            for (n = 0; n < StructuredCoalescentLikelihood.this.demes; ++n) {
                this.startLineageProbs[n] = dArray[n] / d;
            }
            this.intervalLength = 0.0;
            return Math.log(d);
        }

        public void computeEndLineageDensities(double d, double[] dArray) {
            for (int i = 0; i < StructuredCoalescentLikelihood.this.demes; ++i) {
                this.endLineageProbs[i] = StructuredCoalescentLikelihood.rdot(StructuredCoalescentLikelihood.this.demes, this.startLineageProbs, 0, 1, dArray, i, StructuredCoalescentLikelihood.this.demes);
            }
        }

        public void incrementIntervalLength(double d, double[] dArray) {
            this.intervalLength += d;
            if (this.incremented) {
                System.arraycopy(this.endLineageProbs, 0, this.startLineageProbs, 0, StructuredCoalescentLikelihood.this.demes);
                this.computeEndLineageDensities(d, dArray);
            } else {
                this.computeEndLineageDensities(this.intervalLength, dArray);
            }
            this.incremented = true;
        }

        public IntervalType getIntervalType() {
            return this.intervalType;
        }

        public NodeRef getLeftChild() {
            return this.leftChild;
        }

        public NodeRef getRightChild() {
            return this.rightChild;
        }

        public String toString() {
            int n;
            String string = "Node " + this.node + " ; length = " + this.intervalLength + " S(";
            for (n = 0; n < this.startLineageProbs.length; ++n) {
                string = string + this.startLineageProbs[n] + " ";
            }
            string = string + ") E(";
            for (n = 0; n < this.endLineageProbs.length; ++n) {
                string = string + this.endLineageProbs[n] + " ";
            }
            string = string + ")";
            return string;
        }
    }
}

