/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.inference.model.Variable;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WritableVector;

public interface WrappedVector
extends ReadableVector,
WritableVector {
    public double[] getBuffer();

    public int getOffset();

    public static final class Utils {
        public static WrappedVector copy(ReadableVector readableVector) {
            double[] dArray = new double[readableVector.getDim()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = readableVector.get(i);
            }
            return new Raw(dArray);
        }
    }

    public static final class Indexed
    extends Abstract {
        private final int[] indices;

        public Indexed(double[] dArray, int n, int[] nArray, int n2) {
            super(dArray, n, n2);
            this.indices = nArray;
        }

        @Override
        public final double get(int n) {
            return this.buffer[this.offset + this.indices[n]];
        }

        @Override
        public final void set(int n, double d) {
            this.buffer[this.offset + this.indices[n]] = d;
        }
    }

    public static final class Parameter
    extends Abstract {
        private final Variable<Double> variable;

        public Parameter(Variable<Double> variable) {
            this(variable, 0, variable.getSize());
        }

        public Parameter(Variable<Double> variable, int n, int n2) {
            super(null, n, n2);
            this.variable = variable;
        }

        @Override
        public final double get(int n) {
            return this.variable.getValue(this.offset + n);
        }

        @Override
        public final void set(int n, double d) {
            this.variable.setValue(this.offset + n, d);
        }
    }

    public static final class Raw
    extends Abstract {
        public Raw(double[] dArray, int n, int n2) {
            super(dArray, n, n2);
        }

        public Raw(double[] dArray) {
            this(dArray, 0, dArray.length);
        }

        @Override
        public final double get(int n) {
            return this.buffer[this.offset + n];
        }

        @Override
        public final void set(int n, double d) {
            this.buffer[this.offset + n] = d;
        }
    }

    public static abstract class Abstract
    implements WrappedVector {
        protected final double[] buffer;
        protected final int offset;
        protected final int dim;

        public Abstract(double[] dArray, int n, int n2) {
            this.buffer = dArray;
            this.offset = n;
            this.dim = n2;
        }

        @Override
        public final double[] getBuffer() {
            return this.buffer;
        }

        @Override
        public final int getOffset() {
            return this.offset;
        }

        @Override
        public final int getDim() {
            return this.dim;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("[ ");
            if (this.dim > 0) {
                stringBuilder.append(this.get(0));
            }
            for (int i = 1; i < this.dim; ++i) {
                stringBuilder.append(", ").append(this.get(i));
            }
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }
    }
}

