\name{BchronMCMC}
\alias{BchronMCMC}
\title{ Run Bchron model with MCMC }
\description{
  Runs the compound Poisson-Gamma model for radiocarbon and non-radiocarbon dates
}
\usage{
BchronMCMC(Bchrondata, iterations = 0, burnin = 0, thinby = 1, howmany = 1)
}
\arguments{
  \item{Bchrondata}{ A Bchron data object with fields for the the input and output
 files, the name of the core being used, the details of the calibration curve, and details of the 
 model run required. }
  \item{iterations}{ Number of MCMC iterations required. }
  \item{burnin}{ Number of discarded burn-in iterations. }
  \item{thinby}{ Number of iterations to thin out. }
  \item{howmany}{ Number of iterations before R reports back and updates the screen. }
}
\details{
    The Bchron MCMC function fits a compound Poisson-Gamma distribution to the increments between the dated levels. 
    This involves a stochastic linear interpolation where the age gaps are Gamma(2,beta) distributed, and the 
    depth gaps are Exponential(lambda). Radiocarbon dates are updated within the function also by MCMC. 
}
\references{
Haslett and Parnell (2008), A simple monotone process with application to radiocarbon-dated depth chronologies.
Applied Statistics 57 (5), 1--20.
}
\seealso{ \code{\link{Bchronloaddata}} }
\keyword{dplot}
\keyword{programming}
\keyword{models}
\keyword{nonparametric}
\keyword{smooth}
\keyword{package}
