% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_EAP_by_array.R
\name{extract_EAP_CI}
\alias{extract_EAP_CI}
\title{Extracts Estimates as vectors from stanfit objects}
\usage{
extract_EAP_CI(
  StanS4class,
  parameter.name,
  dimension.of.parameter,
  dig = 5,
  summary = TRUE
)
}
\arguments{
\item{StanS4class}{An S4 object of the class \strong{\emph{\code{stanfit}}}. No need that it is the S4 class \strong{\code{ \link{stanfitExtended}}}.}

\item{parameter.name}{character vector. E.g., it is "aaa" for names of parameters described in the parameter block of stan file.}

\item{dimension.of.parameter}{If parameter \code{aaa} is vector,
i.e.,\code{aaa[1],aaa[2],...aaa[6]} then  \code{dimension.of.parameter = 6}}

\item{dig}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
Default = 5,}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\value{
EAPs, CI.
}
\description{
We extract posterior means (in other words, Expected a Posterior:EAP) and credible intervals (CIs) from objects of stanfitExtended S4 class which is an
inherited class of the stanfit S4 class.
}
\details{
Merely, extracts estimates from stanfit objects.
}
\examples{

\dontrun{
# (1) we  fit a model to data and resulting object has the S4-class stanfitExtend.


   fit <- fit_Bayesian_FROC(
                       BayesianFROC::dataList.Chakra.Web.orderd, # data
                              ite = 1111,                        # MCMC iteration
                              summary = FALSE                    # vervose
   )



# (2) To extract the EAPs of the parameter z,
#     we need to specify the dimension of vector z as follows.


       extract_EAP_CI(

                 fit,  #  The above fitted model object
                 "z",  #  The parameter name described in parameter block of stan file
                  5    #  The dimension of vector z
                      )



# One more example: to extract the EAPs of the parameter dz,
# we need to specify its dimension of vector dz as follows.

          list.of.dz <-extract_EAP_CI(fit,"dz",4)

# One more example: to extract the EAPs of the parameter w,
# we need to specify its dimension of vector w as follows.

           list.w  <-extract_EAP_CI(fit,"w",1)


# Note that this function can extract only parameter of "vector" and not "array" !!
# To extract such an array, we provide the function "extract_estimates_MRMC()"
# which extract all parameters from a hierarchical Bayesian model
# estimated from user data. So, this function is no longer meaningless,
# and I will delete this.


# I forgot where I use this function
# 2019.05.21 Revised.
# 2020 Nov 17 Revised


#========================================================================================
#           the following gives convergence seed 2019 Oct 12
#========================================================================================
#'

f <- fit_Bayesian_FROC( ite  = 1111,  cha = 1, summary = TRUE, dataList = ddd ,see = 123456)
  z <- extract_EAP_CI(f,"z",f@dataList$C )$z.EAP
  #usethis::use_data(z)
  #usethis package cannot be to use since it is not declared in NAMESPACE.


  dz <- extract_EAP_CI(f,"dz",f@dataList$C-1 )$dz.EAP
  #usethis::use_data(dz)
  #usethis package cannot be to use since it is not declared in NAMESPACE.
}# dottest



}
\seealso{
\code{\link{extract_estimates_MRMC}}
}
