% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicate_MRMC_data.R
\name{extract_parameters_from_replicated_models}
\alias{extract_parameters_from_replicated_models}
\title{Extract Estimates From Replicated MRMC Model}
\usage{
extract_parameters_from_replicated_models(initial.seed = 123,
  mu.truth = BayesianFROC::mu_truth, v.truth = BayesianFROC::v_truth,
  z.truth = BayesianFROC::z_truth, NI = 200, NL = 142,
  ModifiedPoisson = FALSE, No.of.replication = 2, summary = FALSE,
  ite = 1111)
}
\arguments{
\item{initial.seed}{The variable \code{initial.seed} is used to replicate datasets. That is, if you take initial.seed = 1234, then the seed 1234, 1235, 1236, 1237, 1238, ….. are for the first replication, the second replication, the third replication, …. If the n-th model does not converge for some n, then such model has no mean and thus the non-convergent models are omitted to calculate the errors.}

\item{mu.truth}{array of dimension (M,Q). Mean of represents the signal distribution of bi-normal assumption.}

\item{v.truth}{array of dimension (M,Q). Standard Deviation of represents the signal distribution of bi-normal assumption.}

\item{z.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{NI}{Number of Images.}

\item{NL}{Number of Lesions.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm are \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm are \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.}

\item{No.of.replication}{For fixed number of lesions, images, the dataset of hits and false alarms are replicated, and the number of replicated datasets are specified by this variable.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; whether to list verbose data of estimates when printing. If TRUE then verbose summary and additional estimates are printed in the R console. If FALSE, the output is minimal. I regret, this variable name should be verbose.}

\item{ite}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}
}
\value{
list of estimates
}
\description{
Extract Estimates From Replicated MRMC Model
}
\examples{
\donttest{

 list.of.estimates <- extract_parameters_from_replicated_models()


 }
}
