% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesGLM2_utils.R
\name{beta.posterior.thetasamp}
\alias{beta.posterior.thetasamp}
\title{Beta posterior theta sampling}
\usage{
beta.posterior.thetasamp(
  theta,
  spde,
  Xcros,
  Xycros,
  contrasts,
  quantiles,
  excursion_type,
  gamma,
  alpha,
  nsamp_beta = 100
)
}
\arguments{
\item{theta}{A single sample of theta (hyperparameters) from q(theta|y)}

\item{spde}{A SPDE object from inla.spde2.matern() function.}

\item{Xcros}{A crossproduct of design matrix.}

\item{Xycros}{A crossproduct of design matrix and BOLD y.}

\item{contrasts}{A list of vectors of length M*K specifying the contrasts of interest.}

\item{quantiles}{Vector of posterior quantiles to return in addition to the posterior mean}

\item{excursion_type}{Vector of excursion function type (">", "<", "!=") for each contrast}

\item{gamma}{Vector of activation thresholds for each contrast}

\item{alpha}{Significance level for activation for the excursion sets}

\item{nsamp_beta}{The number of samples to draw from full conditional of beta given the current value of theta (p(beta|theta,y))}
}
\value{
A list containing \code{mu}, \code{quantiles}, and \code{F}
}
\description{
Internal function used in joint approach to group-analysis
}
\section{INLA Requirement}{

This function requires the \code{INLA} package, which is not a CRAN package.
See \url{https://www.r-inla.org/download-install} for easy installation instructions.
}

\keyword{internal}
