% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterTreeCompile.R
\name{ClusterTreeCompile}
\alias{ClusterTreeCompile}
\title{Compile the cluster tree}
\usage{
ClusterTreeCompile(dag, node.class)
}
\arguments{
\item{dag}{a \code{graphNEL} object of the Bayesian network}

\item{node.class}{a named \code{vector} of \code{logical} values, \code{TRUE} if node 
is discrete, \code{FASLE} if otherwise}
}
\value{
\describe{
\item{\code{tree.graph}}{a \code{graphNEL} object of semi-elimination tree.}
\item{\code{dag}}{a \code{graphNEL} object of original Bayesian network.}
\item{\code{cluster.sets}}{a \code{list} of members of each cluster.}
\item{\code{node.class}}{a named \code{vector} of \code{logical} values, \code{TRUE} if node 
is discrete, \code{FASLE} if otherwise}
\item{\code{elimination.order}}{a \code{vector} of node names sorted by the elimination order.}
}
}
\description{
Get the cluster sets and strong semi-elimination tree from the Bayessian network
}
\details{
This function forms the cluster sets and the semi-elimination tree graph
from the Bayesian network. The procedures include acquiring the elimination order,
moralization, triangulation, obtaining cluster sets, forming strong elimination 
tree and strong semi-elimination tree. The cluster sets and the semi-elimination 
tree are required to initialize the cluster tree.
}
\examples{

data(liver)
cst <- ClusterTreeCompile(dag=liver$dag, node.class=liver$node.class)

}
\author{
Han Yu
}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks. 
Journal of Machine Learning Research, 6(Sep), 1517-1550.
}
\seealso{
\code{\link{ElimTreeInitialize}}
}

