% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPPmodel.R
\name{HPPmodel}
\alias{HPPmodel}
\title{Highest posterior probability model}
\usage{
HPPmodel(mcmc)
}
\arguments{
\item{mcmc}{Object of class '\code{befa}'.}
}
\value{
The function returns an object of class '\code{hppm.befa}'
containing:
\itemize{
  \item \code{draws}: Posterior draws of model parameters corresponding to
  the HPP model.
  \item \code{dedic}: Vector of indicators of the the HPP model.
  \item \code{prob}: Posterior probability of the HPP model.
}
}
\description{
This function finds the highest posterior probability (HPP) model, which
corresponds to the indicator matrix most often visited by the sampler across
MCMC iterations.
}
\details{
The HPP model can only be found if identification with respect to
column switching has been restored \emph{a posteriori}. An error message is
returned if this is not the case.

 A warning is issued if the HPP model found is not unique.
}
\examples{
set.seed(6)
Y <- simul.dedic.facmod(N = 200, dedic = rep(1:3, each = 5))
mcmc <- befa(Y, Kmax = 5, iter = 1000)
mcmc <- post.column.switch(mcmc)
hppm <- HPPmodel(mcmc)
hppm$prob
hppm$dedic

}
\author{
Rémi Piatek \email{remi.piatek@econ.ku.dk}
}
\seealso{
\code{\link{post.column.switch}}
}

