% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MCMC.R
\name{plot_MCMC}
\alias{plot_MCMC}
\title{Plot MCMC trajectories and posterior distributions}
\usage{
plot_MCMC(
  object,
  sample_names = NULL,
  variables = c("A", "D", "sD"),
  axes_labels = c(A = "Age (ka)", D = "D (Gy)", sD = "sD (Gy)"),
  n.chains = NULL,
  n.iter = 1000,
  smooth = FALSE,
  rug = TRUE,
  plot_single = FALSE,
  ...
)
}
\arguments{
\item{object}{\link[coda:mcmc.list]{coda::mcmc.list} or \link[coda:mcmc]{coda::mcmc} (\strong{required}): Output generated by \link[rjags:jags.model]{rjags::jags.model},
e.g., in \link{Age_Computation}}

\item{sample_names}{\link{character} (optional): Names of the used samples. This argument overrides the optional
argument \code{mtext}.}

\item{variables}{\link{character} (with default): Variables in your \link[coda:mcmc]{coda::mcmc} object to be plotted.}

\item{axes_labels}{\link{character} (with default): Axes labels used for the trace and density plots. The labels should
be provided as named \link{character} \link{vector} with the parameter names as the names used to assign the axes labelling.
The labelling for the x-axis (trace plots) and y-axis (density plot) cannot be modified.}

\item{n.chains}{\link{numeric} (optional): Set the number of chains to visualise, if nothing is provided the
number of chains is determined from the input object}

\item{n.iter}{\link{integer} (with default): Set the number of iterations to be visualised in the trace plots, regardless
of the size of the input dataset as long as the real number of iterations is > \code{n.iter}.
Please note that large numbers impact the plot performance.}

\item{smooth}{\link{logical} (with default): Enable/disables smooth of trace plots using \link[stats:smooth]{stats::smooth}}

\item{rug}{\link{logical} (with default): Enable/disables \link{rug} under density plots}

\item{plot_single}{\link{logical} (with default): Enables/disables the single plot mode of the function, i.e.
if set to \code{TRUE} every plot is returned in a single plot and own \link{par} settings can be applied.}

\item{...}{further arguments that can be passed to modify the plot output. Supported arguments are
\code{lwd}, \code{lty}, \code{col}, \code{type}, \code{cex},\code{mtext}, cf. \link{mtext} for \code{mtext} and \link{plot.default} for the other
arguments.}
}
\value{
Two plots: Traces of the MCMC chains and the corresponding density plots. This plots
are similar to \link[coda:traceplot]{coda::traceplot} and \link[coda:densplot]{coda::densplot}.
}
\description{
This function uses the output of \link[rjags:jags.model]{rjags::jags.model} to visualise the traces of the MCMC and the
corresponding densities. In particular it displays the posterior distributions of the age, if it is calculated,
palaeodose and the equivalent dose dispersion parameters of the sample. The function output is very
similar to plot output produced with the 'coda' package, but tailored to meet the needs in
the context of the \code{'BayLum'} package.
}
\details{
The function is used in the function \link{Age_Computation}, \link{AgeS_Computation}
and \link{Palaeodose_Computation}, but can be used also as standalone plot function.
}
\section{Function version}{
 0.1.4
}

\examples{
data(MCMCsample,envir = environment())
object <- coda::as.mcmc(MCMCsample)
plot_MCMC(object)

}
\seealso{
\link{Age_Computation}, \link{AgeS_Computation}, \link{Palaeodose_Computation},
\link[rjags:coda.samples]{rjags::coda.samples} and \link{rjags} packages.
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom). This function
is a re-written version of the function 'MCMC_plot()' by Claire Christophe
} 

\section{How to cite}{
Kreutzer, S., Christophe, C., 2020. plot_MCMC(): Plot MCMC trajectories and posterior distributions. Function version 0.1.4. In: Christophe, C., Philippe, A., Kreutzer, S., Guerin, G., 2020. BayLum: Chronological Bayesian Models Integrating Optically Stimulated. R package version 0.2.0. https://CRAN.r-project.org/package=BayLum
}

\keyword{dplot}
