% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.marker.R
\name{drop.marker}
\alias{drop.marker}
\title{Creates a new sequence by dropping markers.}
\usage{
drop.marker(input.seq, mrks)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{mrks}{a vector containing the markers to be removed
from the \code{sequence}.}
}
\value{
An object of class \code{sequence}, which is a list
    containing the following components:

\item{seq.num}{a \code{vector} containing the (ordered) indices of
    markers in the sequence, according to the input file.}

\item{seq.phases}{a \code{vector} with the linkage phases between
    markers in the sequence, in corresponding positions. \code{-1}
    means that there are no defined linkage phases.}

\item{seq.rf}{a \code{vector} with the recombination fractions
    between markers in the sequence. \code{-1} means that there
    are no estimated recombination fractions.}

\item{seq.like}{log-likelihood of the corresponding linkage map.}
    \item{data.name}{name of the object of class \code{outcross}
    with the raw data.}

\item{twopt}{name of the object of class \code{rf.2pts} with the
    2-point analyses.}

 @author Marcelo Mollinari, \email{mmollina@usp.br}
}
\description{
Creates a new sequence by dropping markers from a predetermined
  one.
}
\examples{
data(example.out)
twopt <- rf.2pts(example.out)
all.mark <- make.seq(twopt,"all")
groups <- group(all.mark)
(LG1 <- make.seq(groups,1))
(LG.aug<-drop.marker(LG1, c(10,14)))

}
\seealso{
\code{\link[BatchMap]{add.marker}}
}
