% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMF.R
\name{FMF}
\alias{FMF}
\title{Fuzzy Membership Function Value}
\usage{
FMF(xtheta12)
}
\arguments{
\item{xtheta12}{a numerical vector containing three elements, a distance from query to a potenial species,
maximual or sd of intraspecific variation of the potential species theta1,minimal or mean interspecific
distance.}
}
\value{
a numeric between 0 and 1.
}
\description{
Calculation fuzzy membership function value given a distance from query to a potenial
species, maximual intraspecific variation of the potential species theta1, and minimal interspecific
distance (here, the distance between the potential species and its nearest neighbor theta2) 
(fuzzy-set based method, Zhang et al. 2012), different definition of distances could also be used.
}
\note{
different definitions of distances could also be used.
}
\examples{

xtheta12<-c(0.6289163,0.1465522,0.6379375) 
FMF.out<-FMF(xtheta12)
FMF.out
}
\author{
Ai-bing ZHANG, Zhi-yong SHI. CNU, Beijing, CHINA, contact at zhangab2008(at)mail.cnu.edu.cn
}
\references{
Zhang, A. B., C. Muster, H.B. Liang, C.D. Zhu, R. Crozier, P. Wan, J. Feng, R. D. Ward.(2012). A fuzzy-set-theory-based approach 
to analyse species membership in DNA barcoding. Molecular Ecology, 21(8):1848-63.
}
\keyword{FMF}

