% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\name{selPheno}
\alias{selPheno}
\alias{selPheno,Eval-method}
\title{Function for selecting phenotypes which occured on the arena from specific iterations and species}
\usage{
selPheno(object, time, type, reduce = F)

\S4method{selPheno}{Eval}(object, time, type, reduce = F)
}
\arguments{
\item{object}{An object of class Eval.}

\item{time}{A numeric vector giving the simulation steps which should be plotted.}

\item{type}{A names indicating the species of interest in the arena.}

\item{reduce}{A boolean variable indicating if the resulting matrix should be reduced.}
}
\value{
Returns a matrix with the substrate usage and the number of individuals using the phenotype.
}
\description{
The generic function \code{selPheno} selects phenotypes from specific simulation step in an \code{Eval} object.
}
\details{
The phenotypes are defined by flux through exchange reactions, which indicate potential differential substrate usages.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
selPheno(eval,time=5,type='ecoli_core_model',reduce=TRUE)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{getPhenoMat}}
}
