% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{getPhenoMat}
\alias{getPhenoMat}
\alias{getPhenoMat,Eval-method}
\title{Function for getting a matrix of phenotypes from the dataset}
\usage{
getPhenoMat(object, time = "total", sparse = F)

\S4method{getPhenoMat}{Eval}(object, time = "total", sparse = F)
}
\arguments{
\item{object}{An object of class Eval.}

\item{time}{An integer indicating the time step to be used (default value is character "total")}

\item{sparse}{A boolean indicating whether zero entries should be removed from return matrix}
}
\value{
Returns a matrix with different phenotypes of the organism as rows and all possible exchange reactions as columns. A value of 1 means secretion, 2 means uptake and 0 means no usage of the substance of interest.
}
\description{
The generic function \code{getPhenoMat} reconstructs a matrix with the usage of exchange reactions of the different organisms in the environment.
}
\details{
The phenotypes are defined by flux through exchange reactions, which indicate potential differential substrate usages.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
phenmat <- getPhenoMat(eval)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{getPhenotype}}
}
