% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{growExp}
\alias{growExp}
\alias{growExp,Organism-method}
\title{Function for letting organisms grow exponentially}
\usage{
growExp(object, growth)

\S4method{growExp}{Organism}(object, growth)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{growth}{A number indicating the current biomass, which has to be updated.}
}
\value{
Returns the updated biomass of the organisms of interest.
}
\description{
The generic function \code{growExp} implements a growth model of organisms in their environment.
}
\details{
Exponential growth of organisms is implemented by adding the calculated growthrate multiplied with the current growth calculated by \code{optimizeLP} plus to the already present growth value
}
\examples{
\dontrun{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
org <- Organism(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a organism
growExp(org,1)
}
}
\seealso{
\code{\link{Organism-class}} and \code{\link{optimizeLP}}
}

