% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{checkPhen}
\alias{checkPhen}
\alias{checkPhen,Arena-method}
\title{Function for checking phenotypes in the environment}
\usage{
checkPhen(object, org, cutoff = 1e-06)

\S4method{checkPhen}{Arena}(object, org, cutoff = 1e-06)
}
\arguments{
\item{object}{An object of class Arena.}

\item{org}{An object of class Organism.}

\item{cutoff}{A number giving the cutoff for values of the objective function and fluxes of exchange reactions.}
}
\value{
Returns a number indicating the number of the phenotype in the phenotype list.
}
\description{
The generic function \code{checkPhen} checks and adds the phenotypes of organisms in the environment.
}
\details{
The phenotypes are defined by flux through exchange reactions, which indicate potential differential substrate usages. Uptake of substances are indicated by a negative and production of substances by a positive number.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
checkPhen(arena,bac) #returns 1 as the index of the current phenotype in the list.
}
\seealso{
\code{\link{Arena-class}} and \code{\link{getPhenotype}}
}

