% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_core_Tucker.R
\name{update_core_Tucker}
\alias{update_core_Tucker}
\title{Update values in the core tensor for a Tucker model.}
\usage{
update_core_Tucker(m, d, params)
}
\arguments{
\item{m}{A \code{Tucker_model} object created with \code{mk_model}}

\item{d}{Input data object created with \code{input_data}}

\item{params}{List of parameters created with \code{get_model_params()}}
}
\description{
Update is performed in place to avoid memory issues. There is no return value.
}
\examples{
data.params <- get_data_params(c('decomp=Tucker'))
toy <- mk_toy(data.params)
train.data <- input_data$new(mode1.X=toy$mode1.X[,-1],
                             mode2.X=toy$mode2.X[,-1],
                             mode3.X=toy$mode3.X,
                             resp=toy$resp)
model.params <- get_model_params(c('decomp=Tucker'))
toy.model <- mk_model(train.data, model.params)
toy.model$rand_init(model.params)

update_core_Tucker(m=toy.model, d=train.data, params=model.params)
}

