% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.mixedRegression-method}
\alias{predict,est.mixedRegression-method}
\title{Prediction for a mixed regression model}
\usage{
\S4method{predict}{est.mixedRegression}(object, t, only.interval = TRUE,
  level = 0.05, burnIn, thinning, fun.mat, which.series = c("new",
  "current"), ind.pred, M2pred = 10, cand.length = 1000,
  method = c("vector", "free"), sampling.alg = c("InvMethod", "RejSamp"),
  sample.length, grid, plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.mixedRegression", created with method \code{\link{estimate,mixedRegression-method}}}

\item{t}{vector of time points to make predictions for}

\item{only.interval}{if TRUE: only calculation of prediction intervals}

\item{level}{level of the prediction intervals}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{fun.mat}{matrix-wise definition of drift function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{ind.pred}{index of series to be predicted, optional, if which.series = "current" and ind.pred missing, the last series is taken}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{cand.length}{length of candidate samples (if method = "vector")}

\item{method}{vectorial ("vector") or not ("free")}

\item{sampling.alg}{sampling algorithm, inversion method ("InvMethod") or rejection sampling ("RejSamp")}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{grid}{fineness degree of sampling approximation}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of the regression model
  \eqn{y_{ij} = f(\phi_j, t_{ij}) + \epsilon_{ij}, \phi_j\sim N(\mu, \Omega),
  \epsilon_{ij}\sim N(0,\gamma^2\widetilde{s}(t_{ij}))}.
}
\examples{
mu <- c(10, 5); Omega <- c(0.9, 0.01)
phi <- cbind(rnorm(21, mu[1], sqrt(Omega[1])), rnorm(21, mu[2], sqrt(Omega[2])))
model <- set.to.class("mixedRegression",
         parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 0.1),
         fun = function(phi, t) phi[1]*t + phi[2], sT.fun = function(t) 1)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t)
est <- estimate(model, t, data[1:20,], 2000)
plot(est)
pred <- predict(est, fun.mat = function(phi, t) phi[,1]*t + phi[,2])
points(t, data[21,], pch = 20)

t.list <- list()
for(i in 1:20) t.list[[i]] <- t
t.list[[21]] <- t[1:50]
data.list <- list()
for(i in 1:20) data.list[[i]] <- data[i,]
data.list[[21]] <- data[21, 1:50]
est <- estimate(model, t.list, data.list, 100)
pred <- predict(est, t = t[50:101], which.series = "current", ind.pred = 21,
   fun.mat = function(phi, t) phi[,1]*t + phi[,2])
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

