% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.hiddenmixedDiffusion-method}
\alias{predict,est.hiddenmixedDiffusion-method}
\title{Prediction for a hierarchical (mixed) hidden diffusion process model}
\usage{
\S4method{predict}{est.hiddenmixedDiffusion}(object, t, burnIn, thinning,
  b.fun.mat, which.series = c("new", "current"), ind.pred, M2pred = 10,
  cand.length = 1000, pred.alg = c("Distribution", "Trajectory",
  "simpleTrajectory", "simpleBayesTrajectory"), sample.length, grid,
  plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.hiddenmixedDiffusion", created with method \code{\link{estimate,hiddenmixedDiffusion-method}}}

\item{t}{vector of time points to make predictions for}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{b.fun.mat}{matrix-wise definition of drift function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{ind.pred}{index of series to be predicted, optional, if which.series = "current" and ind.pred missing, the last series is taken}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{cand.length}{length of candidate samples (if method = "vector")}

\item{pred.alg}{prediction algorithm, "Distribution", "Trajectory", "simpleTrajectory" or "simpleBayesTrajectory"}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{grid}{fineness degree of sampling approximation}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of the model
  \eqn{Z_{ij} = Y_{t_{ij}} + \epsilon_{ij}, dY_t = b(\phi_j,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t, \phi_j~N(\mu, \Omega)}.
}
\examples{
mu <- c(5, 1); Omega <- c(0.9, 0.04)
phi <- cbind(rnorm(21, mu[1], sqrt(Omega[1])), rnorm(21, mu[2], sqrt(Omega[2])))
y0.fun <- function(phi, t) phi[2]
model <- set.to.class("hiddenmixedDiffusion", y0.fun = y0.fun,
     b.fun = function(phi, t, y) phi[1],
     parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 1, sigma2 = 0.01))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t)

\dontrun{
est_hidmixdiff <- estimate(model, t, data$Z[1:20,], 200)
plot(est_hidmixdiff)
pred1 <- predict(est_hidmixdiff, b.fun.mat = function(phi, t, y) phi[,1])
pred2 <- predict(est_hidmixdiff, pred.alg = "Trajectory", b.fun.mat = function(phi, t, y) phi[,1])
pred3 <- predict(est_hidmixdiff, pred.alg = "simpleTrajectory", sample.length = nrow(pred1$Y))
lines(t, apply(pred1$Z, 2, quantile, 0.025), col = 3)
lines(t, apply(pred1$Z, 2, quantile, 0.975), col = 3)
lines(t, apply(pred2$Z, 2, quantile, 0.025), col = 4)
lines(t, apply(pred2$Z, 2, quantile, 0.975), col = 4)
pred4 <- predict(est_hidmixdiff, pred.alg = "simpleBayesTrajectory")
}
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

