% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BWStest.r
\docType{package}
\name{BWStest-package}
\alias{BWStest-package}
\title{Baumgartner Weiss Schindler test of equal distributions.}
\description{
Baumgartner Weiss Schindler test.
}
\section{Background}{


The Baumgartner Weiss Schindler test is a two sample test of the null 
that the samples come from the same probability distribution, similar
to the Kolmogorv-Smirnov, Wilcoxon, and Cramer-Von Mises tests. It is
similar to the Cramer-Von Mises test in that it estimates the
square norm of the difference in CDFs of the two samples. However, the
Baumgartner Weiss Schindler test weights the integral by the variance
of the difference in CDFs, "[emphasizing] the tails of the distributions,
which increases the power of the test for a lot of applications."
}

\section{Legal Mumbo Jumbo}{


BWStest is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
W. Baumgartner, P. Weiss, H. Schindler, 'A Nonparametric Test for the General Two-Sample Problem', 
Biometrics, Vol. 54, No. 3 (Sep., 1998), pp. 1129-1135. 
\url{http://doai.io/10.2307/2533862}

M. Neuhauser, 'Exact Tests Based on the Baumgartner-Weiss-Schindler Statistic--A Survey', 
Statistical Papers, Vol 46 (2005), pp. 1-30.
\url{http://doai.io/10.1007/BF02762032}

M. Neuhauser, 'One-Sided Two-Sample and Trend Tests Based on a Modified 
Baumgartner-Weiss-Schindler Statistic', J. Nonparametric Statistics, Vol 13
(2001) pp 729-739.
\url{http://doai.io/10.1080/10485250108832874}

H. Murakami, 'K-Sample Rank Test Based on Modified Baumgartner Statistic and
its Power Comparison', J. Jpn. Comp. Statist. Vol 19 (2006), pp. 1-13.
\url{http://doai.io/10.1080/00949655.2010.551516}
}
\keyword{package}

