% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/97_companion.R
\name{companion}
\alias{companion}
\alias{companion.bvar}
\title{Retrieve companion matrix from a Bayesian VAR}
\usage{
companion(object, ...)

\method{companion}{bvar}(object, type = c("quantile", "mean"), conf_bands = 0.5, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{...}{Not used.}

\item{type}{Character scalar. Whether to return quantile or mean values.
Note that \emph{conf_bands} is ignored for mean values.}

\item{conf_bands}{Numeric vector of confidence bands to apply.
E.g. for bands at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.
Note that the median, i.e. 0.5 is always included.}
}
\value{
Returns a numeric array/matrix of class \code{bvar_comp} with the
VAR's coefficents in companion form at the specified values.
}
\description{
Calculates the companion matrix for Bayesian VARs generated via
\code{\link{bvar}}.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Get companion matrices for confidence bands at 10\%, 50\% and 90\%
companion(x, conf_bands = 0.10)
}
}
\seealso{
\code{\link{bvar}}; \code{\link{coef.bvar}}
}
\keyword{BVAR}
\keyword{analysis}
