% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.PAlive}
\alias{bgcnbd.PAlive}
\alias{mbgcnbd.PAlive}
\title{(M)BG/CNBD-k P(alive)}
\usage{
mbgcnbd.PAlive(params, x, t.x, T.cal)

bgcnbd.PAlive(params, x, t.x, T.cal)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{x}{Number of repeat transactions in the calibration period T.cal, or a
vector of calibration period frequencies.}

\item{t.x}{Recency, i.e. length between first and last transaction during
calibration period.}

\item{T.cal}{Length of calibration period, or a vector of calibration period
lengths.}
}
\value{
Probability that the customer is still alive at the end of the
  calibration period.
}
\description{
Uses (M)BG/CNBD-k model parameters and a customer's past transaction behavior
to return the probability that they are still alive at the end of the
calibration period.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
params <- mbgcnbd.EstimateParameters(cbs)
palive <- mbgcnbd.PAlive(params, cbs$x, cbs$t.x, cbs$T.cal)
head(palive) # Probability of being alive for first 6 customers
mean(palive) # Estimated share of customers to be still alive
}
}
\references{
Platzer Michael, and Thomas Reutterer (submitted)
}

