% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BT_Relative_Influence.R
\name{BT_relative_influence}
\alias{BT_relative_influence}
\title{Method for estimating the relative influence.}
\usage{
BT_relative_influence(
  BTFit_object,
  n.iter,
  rescale = FALSE,
  sort.it = FALSE,
  consider.competing = FALSE,
  consider.surrogates = FALSE
)
}
\arguments{
\item{BTFit_object}{a \code{\link{BTFit}} object.}

\item{n.iter}{number of boosting iteration used for computations. If not provided, the function will perform a best guest approach to determine the optimal number of iterations. In fact,
if a test set was used during the fitting, the retained number of iterations is the one corresponding to the lowest test set error ; otherwise, if cross-validation was performed, the
number of iterations resulting in lowest cross-validation error will be used; otherwise, if the out-of-bag parameter was defined, the OOB error will be used to determine the optimal
number of iterations; otherwise, all iterations will be used.}

\item{rescale}{whether or not the results should be rescaled (divided by the maximum observation). Default set to \code{FALSE}.}

\item{sort.it}{whether or not the results should be (reverse) sorted. Default set to \code{FALSE}.}

\item{consider.competing}{whether or not competing split should be considered in the relative influence computation. Default set to \code{FALSE}.}

\item{consider.surrogates}{whether or not surrogates should be considered in the relative influence computation. Default set to \code{FALSE}.}
}
\value{
Returns by default an unprocessed vector of estimated relative influences. If the \code{rescale} and \code{sort.it} arguments are used, it returns
a processed version of the same vector.
}
\description{
Helper function for computing the relative influence of each variable in the BT object.
}
\details{
This function is not intended for end-user use. It performs the relative influence computation and is called during the summary function.
Note that a permutation approach is not yet implemented.
}
\references{
M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |: GLMs and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries ||: Tree-Based Methods and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |||: Neural Networks and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2022). \strong{Response versus gradient boosting trees, GLMs and neural networks under Tweedie loss and log-link}.
Accepted for publication in \emph{Scandinavian Actuarial Journal}.

M. Denuit, J. Huyghe and J. Trufin (2022). \strong{Boosting cost-complexity pruned trees on Tweedie responses: The ABT machine for insurance ratemaking}.
Paper submitted for publication.

M. Denuit, J. Trufin and T. Verdebout (2022). \strong{Boosting on the responses with Tweedie loss functions}. Paper submitted for publication.
}
\seealso{
\code{\link{BT}}, \code{\link{BTFit}}, \code{\link{BT_perf}}.
}
\author{
Gireg Willame \email{gireg.willame@gmail.com}

\emph{This package is inspired by the \code{gbm3} package. For more details, see \url{https://github.com/gbm-developers/gbm3/}}.
}
