% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Brain}
\alias{Brain}
\title{Brain weight versus body weight of 28 animals}
\format{A data frame/tibble  with 28 observations on three variables
\describe{ 
\item{species}{a factor with levels \code{African
elephant}, \code{Asian Elephant}, \code{Brachiosaurus}, \code{Cat},
\code{Chimpanzee}, \code{Cow}, \code{Diplodocus}, \code{Donkey}, \code{Giraffe},
\code{Goat}, \code{Gorilla}, \code{Gray wolf}, \code{Guinea Pig}, \code{Hamster},
\code{Horse}, \code{Human}, \code{Jaguar}, \code{Kangaroo}, \code{Mole},
\code{Mouse}, \code{Mt Beaver}, \code{Pig}, \code{Potar monkey}, \code{Rabbit},
\code{Rat}, \code{Rhesus monkey}, \code{Sheep}, and \code{Triceratops}}
\item{bodyweight}{body weight (in kg)} 
\item{brainweight}{brain weight (in g)} 
}}
\source{
P. Rousseeuw and A. Leroy, \emph{Robust Regression and Outlier Detection} 
(New York: Wiley, 1987).
}
\usage{
Brain
}
\description{
Data for Exercises 2.15, 2.44, 2.58 and Examples 2.3 and 2.20
}
\examples{

plot(log(brainweight) ~ log(bodyweight), data = Brain, 
     pch = 19, col = "blue", main = "Example 2.3")
mod <- lm(log(brainweight) ~ log(bodyweight), data = Brain)      
abline(mod, lty = "dashed", col = "blue")


}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
