// Generated by rstantools.  Do not edit by hand.

/*
    BPrinStratTTE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BPrinStratTTE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BPrinStratTTE.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_m_exp_nocovar_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 24, column 2 to column 31)",
                                                      " (in 'string', line 25, column 2 to column 27)",
                                                      " (in 'string', line 26, column 2 to column 27)",
                                                      " (in 'string', line 27, column 2 to column 27)",
                                                      " (in 'string', line 28, column 2 to column 27)",
                                                      " (in 'string', line 62, column 2 to column 13)",
                                                      " (in 'string', line 63, column 2 to column 13)",
                                                      " (in 'string', line 64, column 2 to column 15)",
                                                      " (in 'string', line 65, column 2 to column 15)",
                                                      " (in 'string', line 67, column 2 to column 19)",
                                                      " (in 'string', line 68, column 2 to column 19)",
                                                      " (in 'string', line 69, column 2 to column 19)",
                                                      " (in 'string', line 70, column 2 to column 19)",
                                                      " (in 'string', line 71, column 2 to column 16)",
                                                      " (in 'string', line 72, column 2 to column 16)",
                                                      " (in 'string', line 73, column 2 to column 16)",
                                                      " (in 'string', line 74, column 2 to column 16)",
                                                      " (in 'string', line 77, column 2 to column 33)",
                                                      " (in 'string', line 78, column 2 to column 33)",
                                                      " (in 'string', line 82, column 4 to column 54)",
                                                      " (in 'string', line 83, column 4 to column 54)",
                                                      " (in 'string', line 84, column 4 to column 54)",
                                                      " (in 'string', line 85, column 4 to column 54)",
                                                      " (in 'string', line 81, column 18 to line 86, column 3)",
                                                      " (in 'string', line 81, column 2 to line 86, column 3)",
                                                      " (in 'string', line 87, column 2 to column 14)",
                                                      " (in 'string', line 88, column 2 to column 14)",
                                                      " (in 'string', line 89, column 2 to column 14)",
                                                      " (in 'string', line 90, column 2 to column 14)",
                                                      " (in 'string', line 92, column 4 to column 72)",
                                                      " (in 'string', line 93, column 4 to column 72)",
                                                      " (in 'string', line 94, column 4 to column 72)",
                                                      " (in 'string', line 95, column 4 to column 72)",
                                                      " (in 'string', line 91, column 18 to line 96, column 3)",
                                                      " (in 'string', line 91, column 2 to line 96, column 3)",
                                                      " (in 'string', line 97, column 2 to column 29)",
                                                      " (in 'string', line 98, column 2 to column 29)",
                                                      " (in 'string', line 34, column 2 to column 41)",
                                                      " (in 'string', line 35, column 2 to column 45)",
                                                      " (in 'string', line 36, column 2 to column 45)",
                                                      " (in 'string', line 37, column 2 to column 45)",
                                                      " (in 'string', line 38, column 2 to column 45)",
                                                      " (in 'string', line 41, column 11 to column 12)",
                                                      " (in 'string', line 41, column 4 to column 21)",
                                                      " (in 'string', line 53, column 8 to column 74)",
                                                      " (in 'string', line 51, column 37 to line 54, column 7)",
                                                      " (in 'string', line 51, column 13 to line 54, column 7)",
                                                      " (in 'string', line 50, column 8 to column 76)",
                                                      " (in 'string', line 48, column 37 to line 51, column 7)",
                                                      " (in 'string', line 48, column 13 to line 54, column 7)",
                                                      " (in 'string', line 45, column 8 to line 47, column 69)",
                                                      " (in 'string', line 43, column 19 to line 48, column 7)",
                                                      " (in 'string', line 43, column 6 to line 54, column 7)",
                                                      " (in 'string', line 42, column 19 to line 55, column 5)",
                                                      " (in 'string', line 42, column 4 to line 55, column 5)",
                                                      " (in 'string', line 56, column 4 to column 19)",
                                                      " (in 'string', line 40, column 2 to line 57, column 3)",
                                                      " (in 'string', line 4, column 2 to column 29)",
                                                      " (in 'string', line 5, column 2 to column 30)",
                                                      " (in 'string', line 7, column 29 to column 30)",
                                                      " (in 'string', line 7, column 2 to column 32)",
                                                      " (in 'string', line 8, column 29 to column 30)",
                                                      " (in 'string', line 8, column 2 to column 32)",
                                                      " (in 'string', line 9, column 32 to column 33)",
                                                      " (in 'string', line 9, column 2 to column 35)",
                                                      " (in 'string', line 10, column 33 to column 34)",
                                                      " (in 'string', line 10, column 2 to column 36)",
                                                      " (in 'string', line 12, column 2 to column 40)",
                                                      " (in 'string', line 13, column 2 to column 39)",
                                                      " (in 'string', line 14, column 2 to column 39)",
                                                      " (in 'string', line 15, column 2 to column 39)",
                                                      " (in 'string', line 16, column 2 to column 39)",
                                                      " (in 'string', line 19, column 9 to column 11)",
                                                      " (in 'string', line 19, column 2 to column 21)",
                                                      " (in 'string', line 67, column 9 to column 11)",
                                                      " (in 'string', line 68, column 9 to column 11)",
                                                      " (in 'string', line 69, column 9 to column 11)",
                                                      " (in 'string', line 70, column 9 to column 11)"};
#include <stan_meta_header.hpp>
class model_m_exp_nocovar final : public model_base_crtp<model_m_exp_nocovar> {
private:
  int n;
  int tg;
  std::vector<int> Z;
  std::vector<int> S;
  std::vector<double> TIME;
  std::vector<int> EVENT;
  std::vector<double> prior_piT;
  std::vector<double> prior_0N;
  std::vector<double> prior_1N;
  std::vector<double> prior_0T;
  std::vector<double> prior_1T;
  Eigen::Matrix<double, -1, 1> t_grid;
 
public:
  ~model_m_exp_nocovar() { }
  
  inline std::string model_name() const final { return "model_m_exp_nocovar"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_m_exp_nocovar(stan::io::var_context& context__,
                      unsigned int random_seed__ = 0,
                      std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_m_exp_nocovar_namespace::model_m_exp_nocovar";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 58;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 58;
      current_statement__ = 58;
      check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 59;
      context__.validate_dims("data initialization","tg","int",
          context__.to_vec());
      tg = std::numeric_limits<int>::min();
      
      current_statement__ = 59;
      tg = context__.vals_i("tg")[(1 - 1)];
      current_statement__ = 59;
      current_statement__ = 59;
      check_greater_or_equal(function__, "tg", tg, 1);
      current_statement__ = 60;
      validate_non_negative_index("Z", "n", n);
      current_statement__ = 61;
      context__.validate_dims("data initialization","Z","int",
          context__.to_vec(n));
      Z = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 61;
      assign(Z, nil_index_list(), context__.vals_i("Z"),
        "assigning variable Z");
      current_statement__ = 61;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 61;
        current_statement__ = 61;
        check_greater_or_equal(function__, "Z[sym1__]", Z[(sym1__ - 1)], 0);}
      current_statement__ = 61;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 61;
        current_statement__ = 61;
        check_less_or_equal(function__, "Z[sym1__]", Z[(sym1__ - 1)], 1);}
      current_statement__ = 62;
      validate_non_negative_index("S", "n", n);
      current_statement__ = 63;
      context__.validate_dims("data initialization","S","int",
          context__.to_vec(n));
      S = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 63;
      assign(S, nil_index_list(), context__.vals_i("S"),
        "assigning variable S");
      current_statement__ = 63;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 63;
        current_statement__ = 63;
        check_greater_or_equal(function__, "S[sym1__]", S[(sym1__ - 1)], 0);}
      current_statement__ = 63;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 63;
        current_statement__ = 63;
        check_less_or_equal(function__, "S[sym1__]", S[(sym1__ - 1)], 1);}
      current_statement__ = 64;
      validate_non_negative_index("TIME", "n", n);
      current_statement__ = 65;
      context__.validate_dims("data initialization","TIME","double",
          context__.to_vec(n));
      TIME = std::vector<double>(n, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 65;
      assign(TIME, nil_index_list(), context__.vals_r("TIME"),
        "assigning variable TIME");
      current_statement__ = 65;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 65;
        current_statement__ = 65;
        check_greater_or_equal(function__, "TIME[sym1__]",
                               TIME[(sym1__ - 1)], 0);}
      current_statement__ = 66;
      validate_non_negative_index("EVENT", "n", n);
      current_statement__ = 67;
      context__.validate_dims("data initialization","EVENT","int",
          context__.to_vec(n));
      EVENT = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 67;
      assign(EVENT, nil_index_list(), context__.vals_i("EVENT"),
        "assigning variable EVENT");
      current_statement__ = 67;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 67;
        current_statement__ = 67;
        check_greater_or_equal(function__, "EVENT[sym1__]",
                               EVENT[(sym1__ - 1)], 0);}
      current_statement__ = 67;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 67;
        current_statement__ = 67;
        check_less_or_equal(function__, "EVENT[sym1__]", EVENT[(sym1__ - 1)],
                            1);}
      current_statement__ = 68;
      context__.validate_dims("data initialization","prior_piT","double",
          context__.to_vec(2));
      prior_piT = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 68;
      assign(prior_piT, nil_index_list(), context__.vals_r("prior_piT"),
        "assigning variable prior_piT");
      current_statement__ = 68;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 68;
        current_statement__ = 68;
        check_greater_or_equal(function__, "prior_piT[sym1__]",
                               prior_piT[(sym1__ - 1)], 0);}
      current_statement__ = 69;
      context__.validate_dims("data initialization","prior_0N","double",
          context__.to_vec(2));
      prior_0N = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 69;
      assign(prior_0N, nil_index_list(), context__.vals_r("prior_0N"),
        "assigning variable prior_0N");
      current_statement__ = 69;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 69;
        current_statement__ = 69;
        check_greater_or_equal(function__, "prior_0N[sym1__]",
                               prior_0N[(sym1__ - 1)], 0);}
      current_statement__ = 70;
      context__.validate_dims("data initialization","prior_1N","double",
          context__.to_vec(2));
      prior_1N = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 70;
      assign(prior_1N, nil_index_list(), context__.vals_r("prior_1N"),
        "assigning variable prior_1N");
      current_statement__ = 70;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 70;
        current_statement__ = 70;
        check_greater_or_equal(function__, "prior_1N[sym1__]",
                               prior_1N[(sym1__ - 1)], 0);}
      current_statement__ = 71;
      context__.validate_dims("data initialization","prior_0T","double",
          context__.to_vec(2));
      prior_0T = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 71;
      assign(prior_0T, nil_index_list(), context__.vals_r("prior_0T"),
        "assigning variable prior_0T");
      current_statement__ = 71;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 71;
        current_statement__ = 71;
        check_greater_or_equal(function__, "prior_0T[sym1__]",
                               prior_0T[(sym1__ - 1)], 0);}
      current_statement__ = 72;
      context__.validate_dims("data initialization","prior_1T","double",
          context__.to_vec(2));
      prior_1T = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 72;
      assign(prior_1T, nil_index_list(), context__.vals_r("prior_1T"),
        "assigning variable prior_1T");
      current_statement__ = 72;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 72;
        current_statement__ = 72;
        check_greater_or_equal(function__, "prior_1T[sym1__]",
                               prior_1T[(sym1__ - 1)], 0);}
      current_statement__ = 73;
      validate_non_negative_index("t_grid", "tg", tg);
      current_statement__ = 74;
      context__.validate_dims("data initialization","t_grid","double",
          context__.to_vec(tg));
      t_grid = Eigen::Matrix<double, -1, 1>(tg);
      stan::math::fill(t_grid, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> t_grid_flat__;
        current_statement__ = 74;
        assign(t_grid_flat__, nil_index_list(), context__.vals_r("t_grid"),
          "assigning variable t_grid_flat__");
        current_statement__ = 74;
        pos__ = 1;
        current_statement__ = 74;
        for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
          current_statement__ = 74;
          assign(t_grid, cons_list(index_uni(sym1__), nil_index_list()),
            t_grid_flat__[(pos__ - 1)], "assigning variable t_grid");
          current_statement__ = 74;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 75;
      validate_non_negative_index("S_0N", "tg", tg);
      current_statement__ = 76;
      validate_non_negative_index("S_1N", "tg", tg);
      current_statement__ = 77;
      validate_non_negative_index("S_0T", "tg", tg);
      current_statement__ = 78;
      validate_non_negative_index("S_1T", "tg", tg);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_m_exp_nocovar_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ pi_T;
      pi_T = DUMMY_VAR__;
      
      current_statement__ = 1;
      pi_T = in__.scalar();
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        pi_T = stan::math::lub_constrain(pi_T, 0, 1, lp__);
      } else {
        current_statement__ = 1;
        pi_T = stan::math::lub_constrain(pi_T, 0, 1);
      }
      local_scalar_t__ lambda_0N;
      lambda_0N = DUMMY_VAR__;
      
      current_statement__ = 2;
      lambda_0N = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        lambda_0N = stan::math::lb_constrain(lambda_0N, 0, lp__);
      } else {
        current_statement__ = 2;
        lambda_0N = stan::math::lb_constrain(lambda_0N, 0);
      }
      local_scalar_t__ lambda_1N;
      lambda_1N = DUMMY_VAR__;
      
      current_statement__ = 3;
      lambda_1N = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        lambda_1N = stan::math::lb_constrain(lambda_1N, 0, lp__);
      } else {
        current_statement__ = 3;
        lambda_1N = stan::math::lb_constrain(lambda_1N, 0);
      }
      local_scalar_t__ lambda_0T;
      lambda_0T = DUMMY_VAR__;
      
      current_statement__ = 4;
      lambda_0T = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        lambda_0T = stan::math::lb_constrain(lambda_0T, 0, lp__);
      } else {
        current_statement__ = 4;
        lambda_0T = stan::math::lb_constrain(lambda_0T, 0);
      }
      local_scalar_t__ lambda_1T;
      lambda_1T = DUMMY_VAR__;
      
      current_statement__ = 5;
      lambda_1T = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        lambda_1T = stan::math::lb_constrain(lambda_1T, 0, lp__);
      } else {
        current_statement__ = 5;
        lambda_1T = stan::math::lb_constrain(lambda_1T, 0);
      }
      {
        current_statement__ = 38;
        lp_accum__.add(
          beta_lpdf<propto__>(pi_T, prior_piT[(1 - 1)], prior_piT[(2 - 1)]));
        current_statement__ = 39;
        lp_accum__.add(
          gamma_lpdf<propto__>(lambda_0N, prior_0N[(1 - 1)],
            prior_0N[(2 - 1)]));
        current_statement__ = 40;
        lp_accum__.add(
          gamma_lpdf<propto__>(lambda_1N, prior_1N[(1 - 1)],
            prior_1N[(2 - 1)]));
        current_statement__ = 41;
        lp_accum__.add(
          gamma_lpdf<propto__>(lambda_0T, prior_0T[(1 - 1)],
            prior_0T[(2 - 1)]));
        current_statement__ = 42;
        lp_accum__.add(
          gamma_lpdf<propto__>(lambda_1T, prior_1T[(1 - 1)],
            prior_1T[(2 - 1)]));
        {
          current_statement__ = 43;
          validate_non_negative_index("prob", "n", n);
          Eigen::Matrix<local_scalar_t__, -1, 1> prob;
          prob = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
          stan::math::fill(prob, DUMMY_VAR__);
          
          current_statement__ = 55;
          for (int i = 1; i <= n; ++i) {
            current_statement__ = 53;
            if (logical_eq(Z[(i - 1)], 0)) {
              current_statement__ = 51;
              assign(prob, cons_list(index_uni(i), nil_index_list()),
                log_mix(pi_T,
                  ((EVENT[(i - 1)] * stan::math::log(lambda_0T)) -
                    (lambda_0T * TIME[(i - 1)])),
                  ((EVENT[(i - 1)] * stan::math::log(lambda_0N)) -
                    (lambda_0N * TIME[(i - 1)]))), "assigning variable prob");
            } else {
              current_statement__ = 50;
              if ((primitive_value(logical_eq(Z[(i - 1)], 1)) &&
                  primitive_value(logical_eq(S[(i - 1)], 0)))) {
                current_statement__ = 48;
                assign(prob, cons_list(index_uni(i), nil_index_list()),
                  (log1m(pi_T) +
                    ((EVENT[(i - 1)] * stan::math::log(lambda_1N)) -
                      (lambda_1N * TIME[(i - 1)]))),
                  "assigning variable prob");
              } else {
                current_statement__ = 47;
                if ((primitive_value(logical_eq(Z[(i - 1)], 1)) &&
                    primitive_value(logical_eq(S[(i - 1)], 1)))) {
                  current_statement__ = 45;
                  assign(prob, cons_list(index_uni(i), nil_index_list()),
                    (stan::math::log(pi_T) +
                      ((EVENT[(i - 1)] * stan::math::log(lambda_1T)) -
                        (lambda_1T * TIME[(i - 1)]))),
                    "assigning variable prob");
                } 
              }
            }}
          current_statement__ = 56;
          lp_accum__.add(prob);
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_m_exp_nocovar_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double pi_T;
      pi_T = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      pi_T = in__.scalar();
      current_statement__ = 1;
      pi_T = stan::math::lub_constrain(pi_T, 0, 1);
      double lambda_0N;
      lambda_0N = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      lambda_0N = in__.scalar();
      current_statement__ = 2;
      lambda_0N = stan::math::lb_constrain(lambda_0N, 0);
      double lambda_1N;
      lambda_1N = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      lambda_1N = in__.scalar();
      current_statement__ = 3;
      lambda_1N = stan::math::lb_constrain(lambda_1N, 0);
      double lambda_0T;
      lambda_0T = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      lambda_0T = in__.scalar();
      current_statement__ = 4;
      lambda_0T = stan::math::lb_constrain(lambda_0T, 0);
      double lambda_1T;
      lambda_1T = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      lambda_1T = in__.scalar();
      current_statement__ = 5;
      lambda_1T = stan::math::lb_constrain(lambda_1T, 0);
      vars__.emplace_back(pi_T);
      vars__.emplace_back(lambda_0N);
      vars__.emplace_back(lambda_1N);
      vars__.emplace_back(lambda_0T);
      vars__.emplace_back(lambda_1T);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      double hr_N;
      hr_N = std::numeric_limits<double>::quiet_NaN();
      
      double hr_T;
      hr_T = std::numeric_limits<double>::quiet_NaN();
      
      double rmst_N;
      rmst_N = std::numeric_limits<double>::quiet_NaN();
      
      double rmst_T;
      rmst_T = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> S_0N;
      S_0N = Eigen::Matrix<double, -1, 1>(tg);
      stan::math::fill(S_0N, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> S_1N;
      S_1N = Eigen::Matrix<double, -1, 1>(tg);
      stan::math::fill(S_1N, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> S_0T;
      S_0T = Eigen::Matrix<double, -1, 1>(tg);
      stan::math::fill(S_0T, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> S_1T;
      S_1T = Eigen::Matrix<double, -1, 1>(tg);
      stan::math::fill(S_1T, std::numeric_limits<double>::quiet_NaN());
      
      double rmst_0N;
      rmst_0N = std::numeric_limits<double>::quiet_NaN();
      
      double rmst_1N;
      rmst_1N = std::numeric_limits<double>::quiet_NaN();
      
      double rmst_0T;
      rmst_0T = std::numeric_limits<double>::quiet_NaN();
      
      double rmst_1T;
      rmst_1T = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 18;
      hr_N = (lambda_1N / lambda_0N);
      current_statement__ = 19;
      hr_T = (lambda_1T / lambda_0T);
      current_statement__ = 25;
      for (int t = 1; t <= tg; ++t) {
        current_statement__ = 20;
        assign(S_0N, cons_list(index_uni(t), nil_index_list()),
          (1 - exponential_cdf(t_grid[(t - 1)], lambda_0N)),
          "assigning variable S_0N");
        current_statement__ = 21;
        assign(S_1N, cons_list(index_uni(t), nil_index_list()),
          (1 - exponential_cdf(t_grid[(t - 1)], lambda_1N)),
          "assigning variable S_1N");
        current_statement__ = 22;
        assign(S_0T, cons_list(index_uni(t), nil_index_list()),
          (1 - exponential_cdf(t_grid[(t - 1)], lambda_0T)),
          "assigning variable S_0T");
        current_statement__ = 23;
        assign(S_1T, cons_list(index_uni(t), nil_index_list()),
          (1 - exponential_cdf(t_grid[(t - 1)], lambda_1T)),
          "assigning variable S_1T");}
      current_statement__ = 26;
      rmst_0N = 0;
      current_statement__ = 27;
      rmst_1N = 0;
      current_statement__ = 28;
      rmst_0T = 0;
      current_statement__ = 29;
      rmst_1T = 0;
      current_statement__ = 35;
      for (int j = 2; j <= tg; ++j) {
        current_statement__ = 30;
        rmst_0N = (rmst_0N +
                    (((S_0N[((j - 1) - 1)] + S_0N[(j - 1)]) / 2) *
                      (t_grid[(j - 1)] - t_grid[((j - 1) - 1)])));
        current_statement__ = 31;
        rmst_1N = (rmst_1N +
                    (((S_1N[((j - 1) - 1)] + S_1N[(j - 1)]) / 2) *
                      (t_grid[(j - 1)] - t_grid[((j - 1) - 1)])));
        current_statement__ = 32;
        rmst_0T = (rmst_0T +
                    (((S_0T[((j - 1) - 1)] + S_0T[(j - 1)]) / 2) *
                      (t_grid[(j - 1)] - t_grid[((j - 1) - 1)])));
        current_statement__ = 33;
        rmst_1T = (rmst_1T +
                    (((S_1T[((j - 1) - 1)] + S_1T[(j - 1)]) / 2) *
                      (t_grid[(j - 1)] - t_grid[((j - 1) - 1)])));}
      current_statement__ = 36;
      rmst_N = (rmst_1N - rmst_0N);
      current_statement__ = 37;
      rmst_T = (rmst_1T - rmst_0T);
      vars__.emplace_back(hr_N);
      vars__.emplace_back(hr_T);
      vars__.emplace_back(rmst_N);
      vars__.emplace_back(rmst_T);
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        vars__.emplace_back(S_0N[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        vars__.emplace_back(S_1N[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        vars__.emplace_back(S_0T[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        vars__.emplace_back(S_1T[(sym1__ - 1)]);}
      vars__.emplace_back(rmst_0N);
      vars__.emplace_back(rmst_1N);
      vars__.emplace_back(rmst_0T);
      vars__.emplace_back(rmst_1T);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double pi_T;
      pi_T = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      pi_T = context__.vals_r("pi_T")[(1 - 1)];
      double pi_T_free__;
      pi_T_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      pi_T_free__ = stan::math::lub_free(pi_T, 0, 1);
      double lambda_0N;
      lambda_0N = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      lambda_0N = context__.vals_r("lambda_0N")[(1 - 1)];
      double lambda_0N_free__;
      lambda_0N_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      lambda_0N_free__ = stan::math::lb_free(lambda_0N, 0);
      double lambda_1N;
      lambda_1N = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      lambda_1N = context__.vals_r("lambda_1N")[(1 - 1)];
      double lambda_1N_free__;
      lambda_1N_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      lambda_1N_free__ = stan::math::lb_free(lambda_1N, 0);
      double lambda_0T;
      lambda_0T = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      lambda_0T = context__.vals_r("lambda_0T")[(1 - 1)];
      double lambda_0T_free__;
      lambda_0T_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      lambda_0T_free__ = stan::math::lb_free(lambda_0T, 0);
      double lambda_1T;
      lambda_1T = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      lambda_1T = context__.vals_r("lambda_1T")[(1 - 1)];
      double lambda_1T_free__;
      lambda_1T_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      lambda_1T_free__ = stan::math::lb_free(lambda_1T, 0);
      vars__.emplace_back(pi_T_free__);
      vars__.emplace_back(lambda_0N_free__);
      vars__.emplace_back(lambda_1N_free__);
      vars__.emplace_back(lambda_0T_free__);
      vars__.emplace_back(lambda_1T_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("pi_T");
    names__.emplace_back("lambda_0N");
    names__.emplace_back("lambda_1N");
    names__.emplace_back("lambda_0T");
    names__.emplace_back("lambda_1T");
    names__.emplace_back("hr_N");
    names__.emplace_back("hr_T");
    names__.emplace_back("rmst_N");
    names__.emplace_back("rmst_T");
    names__.emplace_back("S_0N");
    names__.emplace_back("S_1N");
    names__.emplace_back("S_0T");
    names__.emplace_back("S_1T");
    names__.emplace_back("rmst_0N");
    names__.emplace_back("rmst_1N");
    names__.emplace_back("rmst_0T");
    names__.emplace_back("rmst_1T");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tg)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tg)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tg)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tg)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "pi_T");
    param_names__.emplace_back(std::string() + "lambda_0N");
    param_names__.emplace_back(std::string() + "lambda_1N");
    param_names__.emplace_back(std::string() + "lambda_0T");
    param_names__.emplace_back(std::string() + "lambda_1T");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "hr_N");
      param_names__.emplace_back(std::string() + "hr_T");
      param_names__.emplace_back(std::string() + "rmst_N");
      param_names__.emplace_back(std::string() + "rmst_T");
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_0N" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_1N" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_0T" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_1T" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "rmst_0N");
      param_names__.emplace_back(std::string() + "rmst_1N");
      param_names__.emplace_back(std::string() + "rmst_0T");
      param_names__.emplace_back(std::string() + "rmst_1T");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "pi_T");
    param_names__.emplace_back(std::string() + "lambda_0N");
    param_names__.emplace_back(std::string() + "lambda_1N");
    param_names__.emplace_back(std::string() + "lambda_0T");
    param_names__.emplace_back(std::string() + "lambda_1T");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "hr_N");
      param_names__.emplace_back(std::string() + "hr_T");
      param_names__.emplace_back(std::string() + "rmst_N");
      param_names__.emplace_back(std::string() + "rmst_T");
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_0N" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_1N" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_0T" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= tg; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "S_1T" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "rmst_0N");
      param_names__.emplace_back(std::string() + "rmst_1N");
      param_names__.emplace_back(std::string() + "rmst_0T");
      param_names__.emplace_back(std::string() + "rmst_1T");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"pi_T\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_0N\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_1N\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_0T\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_1T\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hr_N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"hr_T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"S_0N\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"S_1N\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"S_0T\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"S_1T\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"rmst_0N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_1N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_0T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_1T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"pi_T\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_0N\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_1N\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_0T\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda_1T\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hr_N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"hr_T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"S_0N\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"S_1N\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"S_0T\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"S_1T\",\"type\":{\"name\":\"vector\",\"length\":" << tg << "},\"block\":\"generated_quantities\"},{\"name\":\"rmst_0N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_1N\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_0T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rmst_1T\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_m_exp_nocovar_namespace::model_m_exp_nocovar;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_m_exp_nocovar_namespace::profiles__;
}
#endif
#endif
