% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/next.subtrial.R
\name{next.subtrial}
\alias{next.subtrial}
\title{Determine the starting dose and the dose-searching space for next subtrial in waterfall design}
\usage{
next.subtrial(target, npts, ntox, p.saf = 0.6 * target, p.tox = 1.4 *
  target, cutoff.eli = 0.95, extrasafe = FALSE, offset = 0.05)
}
\arguments{
\item{target}{the target toxicity rate}

\item{npts}{a \code{J*K} matrix \code{(J<=K)} containing the number of patients treated at each dose combination}

\item{ntox}{a \code{J*K} matrix \code{(J<=K)} containing the number of patients who experienced dose-limiting
toxicities at each dose combination}

\item{p.saf}{the highest toxicity probability that is deemed subtherapeutic (i.e. below
the MTD) such that dose escalation should be undertaken. The default value
is \code{p.saf=0.6*target}.}

\item{p.tox}{the lowest toxicity probability that is deemed overly toxic such that
deescalation is required. The default value is \code{p.tox=1.4*target}.}

\item{cutoff.eli}{the cutoff to eliminate an overly toxic dose for safety. We recommend
the default value of (\code{cutoff.eli=0.95}) for general use.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more stringent stopping rule}

\item{offset}{a small positive number (between 0 and 0.5) to control how strict the
              stopping rule is when \code{extrasafe=TRUE}. A larger value leads to a
              more strict stopping rule. The default value \code{offset=0.05} generally
              works well.}
}
\value{
\code{next.subtrial()} returns the starting dose and the dose-searching space for
        the next subtrial.
}
\description{
Determine the starting dose and the dose-searching space for next subtrial after
the current subtrial is completed when using the waterfall design
}
\details{
For the waterfall design, this function is used to obtain the starting dose and
         dose-searching space for the next subtrial when the current subtrial is completed.
         The input data include: the number of patients treated at each dose combination
          (i.e., \code{npts}), the number of patients who experienced dose-limiting
          toxicities at each dose combination (i.e., \code{ntox}).
}
\examples{
n<-matrix(c(6, 0, 0, 0,
           6, 10, 12, 0,
           9, 12, 0, 0), ncol=4, byrow=TRUE)
y<-matrix(c(0, 0, 0, 0,
            1, 1, 4, 0,
            2, 3, 0, 0), ncol=4, byrow=TRUE)

next.subtrial(target=0.3, npts=n, ntox=y)
}
\author{
Suyu Liu and Ying Yuan
}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
            Trials, Journal of the Royal Statistical Society: Series C, 64, 507-523.

           Lin R. and Yin, G. (2016). Bayesian Optimal Interval Designs for Dose Finding in
           Drug-combination Trials, Statistical Methods in Medical Research, to appear.

           Zhang L. and Yuan, Y. (2016). A Simple Bayesian Design to Identify the Maximum
           Tolerated Dose Contour for Drug Combination Trials, under review.
}
\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.4_tutorial.pdf}

          Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

