# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @export
#' @name MAR_L
#' @title C++ function to estimate Pitman-Yor univariate mixtures via marginal sampler - LOCATION
#' @keywords internal
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param s20 variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param m1 hyperparameter, mean of distribution of m0
#' @param k1 hyperparameter, scale factor of distribution of m0
#' @param a1 hyperparameter, shape of distribution of s20
#' @param b1 hyperparameter, scale of distribution of s20
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param process if 0 DP, if 1 PY
#' @param sigma_PY discount parameter
#' @param print_message print the status
#' @param hyper, if TRUE use hyperpriors, default TRUE
#'
NULL

#' @export
#' @name MAR
#' @title C++ function to estimate Pitman-Yor univariate mixtures via marginal sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param m1 mean of hyperdistribution of m0
#' @param s21 variance of hyperdistribution of m0
#' @param tau1 shape parameter of hyperdistribution of k0
#' @param tau2 rate parameter of hyperdistribution of k0
#' @param a1 shape parameter of hyperdistribution of b0
#' @param b1 rate parameter of hyperdistribution of b0
#' @param mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param process if 0 DP, if 1 PY
#' @param sigma_PY discount parameter
#' @param print_message print the status
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name MAR_mv_L
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via marginal sampler - LOCATION
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param S20 variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param m1 mean of hyperdistribtion of m0
#' @param k1 scale factor of hyperdistribtion of m0
#' @param theta1 df of hyperdistribtion of S20
#' @param Theta1 matrix of hyperdistribution of S20
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name MAR_mv
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via marginal sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param m1 mean of hyperprior distribution of m0
#' @param S1 covariance of hyperprior distribution of m0
#' @param tau1 shape parameter of hyperprior distribution of k0
#' @param tau2 rate parameter of hyperprior distribution of k0
#' @param theta1 df of hyperprior distribution of S0
#' @param Theta1 matrix of hyperprior distribution of S0
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name MAR_mv_P
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via marginal sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 vector, scale parameters for the location component
#' @param a0 vector, parameters of scale component
#' @param b0 vector, parameters of scale component
#' @param m1 means of hyperdistribution of m0
#' @param s21 variances of hyperdistribution of m0
#' @param tau1 shape parameters of hyperdistribution of k0
#' @param tau2 rate parameters of hyperdistribution of k0
#' @param a1 shape parameters of hyperdistribution of b0
#' @param b1 rate parameters of hyperdistribution of b0
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name MAR_mv_MKR
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via marginal sampler - PRODUCT KERNEL
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 vector, scale parameters for the location component
#' @param a0 vector, parameters of scale component
#' @param b0 vector, parameters of scale component
#' @param m1 means of hyperdistribution of m0
#' @param s21 variances of hyperdistribution of m0
#' @param tau1 shape parameters of hyperdistribution of k0
#' @param tau2 rate parameters of hyperdistribution of k0
#' @param a1 shape parameters of hyperdistribution of b0
#' @param b1 rate parameters of hyperdistribution of b0
#' @param strength strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

MAR_L <- function(data, grid, niter, nburn, m0, s20, a0, b0, m1, k1, a1, b1, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, hyper = 1L) {
    .Call('_BNPmix_MAR_L', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, s20, a0, b0, m1, k1, a1, b1, mass, nupd, out_param, out_dens, sigma_PY, print_message, hyper)
}

MAR <- function(data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, hyper = 1L) {
    .Call('_BNPmix_MAR', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, nupd, out_param, out_dens, sigma_PY, print_message, hyper)
}

MAR_mv_L <- function(data, grid, niter, nburn, m0, S20, S0, n0, m1, k1, theta1, Theta1, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_MAR_mv_L', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, S20, S0, n0, m1, k1, theta1, Theta1, mass, nupd, out_param, out_dens, sigma_PY, print_message, light_dens, hyper)
}

MAR_mv <- function(data, grid, niter, nburn, m0, k0, S0, n0, m1, S1, tau1, tau2, theta1, Theta1, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_MAR_mv', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, S0, n0, m1, S1, tau1, tau2, theta1, Theta1, mass, nupd, out_param, out_dens, sigma_PY, print_message, light_dens, hyper)
}

MAR_mv_P <- function(data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_MAR_mv_P', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, nupd, out_param, out_dens, sigma_PY, print_message, light_dens, hyper)
}

MAR_mv_MKR <- function(y, covs, grid_response, grid_covs, niter, nburn, beta0, Sb0, a0, b0, beta1, k1, sb1, Sb1, tau1, tau2, strength, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_MAR_mv_MKR', PACKAGE = 'BNPmix', y, covs, grid_response, grid_covs, niter, nburn, beta0, Sb0, a0, b0, beta1, k1, sb1, Sb1, tau1, tau2, strength, napprox, nupd, out_param, out_dens, discount, print_message, light_dens, hyper)
}

#' @export
#' @name cDDP
#' @title C++ function to estimate DDP models with 1 grouping variables
#' @keywords internal
#'
#' @param data a vector of observations.
#' @param group group allocation of the data.
#' @param ngr number of groups.
#' @param grid vector to evaluate the density.
#' @param niter number of iterations.
#' @param nburn number of burn-in iterations.
#' @param m0 expectation of location component.
#' @param k0 tuning parameter of variance of location component.
#' @param a0 parameter of scale component.
#' @param b0 parameter of scale component.
#' @param mass mass of Dirichlet process.
#' @param wei prior weight of the specific processes.
#' @param b tuning parameter of weights distribution
#' @param napprox number of approximating values.
#' @param n_approx_unif number of approximating values of the importance step for the weights updating.
#' @param nupd number of iterations to show current updating.
#' @param out_dens if TRUE, return also the estimated density (default TRUE).
#' @param print_message print the status.
#' @param light_dens if TRUE return only the posterior mean of the density
#'
NULL

cDDP <- function(data, group, ngr, grid, niter, nburn, m0, k0, a0, b0, mass, wei, napprox, n_approx_unif, nupd = 0L, out_dens = 1L, print_message = 1L, light_dens = 1L) {
    .Call('_BNPmix_cDDP', PACKAGE = 'BNPmix', data, group, ngr, grid, niter, nburn, m0, k0, a0, b0, mass, wei, napprox, n_approx_unif, nupd, out_dens, print_message, light_dens)
}

#' @export
#' @name cICS_L
#' @title C++ function to estimate Pitman-Yor univariate mixtures via importance conditional sampler - LOCATION
#' @keywords internal
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param s20 variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param m1 hyperparameter, mean of distribution of m0
#' @param k1 hyperparameter, scale factor of distribution of m0
#' @param a1 hyperparameter, shape of distribution of s20
#' @param b1 hyperparameter, scale of distribution of s20
#' @param strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount discount parameter
#' @param print_message print the status
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name cICS
#' @title C++ function to estimate Pitman-Yor univariate mixtures via importance conditional sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param m1 mean of hyperdistribution of m0
#' @param s21 variance of hyperdistribution of m0
#' @param tau1 shape parameter of hyperdistribution of k0
#' @param tau2 rate parameter of hyperdistribution of k0
#' @param a1 shape parameter of hyperdistribution of b0
#' @param b1 rate parameter of hyperdistribution of b0
#' @param strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount discount parameter
#' @param print_message print the status
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name cICS_mv_L
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via importance conditional sampler
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param S20 variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param m1 mean of hyperdistribtion of m0
#' @param k1 scale factor of hyperdistribtion of m0
#' @param theta1 df of hyperdistribtion of S20
#' @param Theta1 matrix of hyperdistribution of S20
#' @param strength strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name cICS_mv
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via importance conditional sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param m1 mean of hyperprior distribution of m0
#' @param S1 covariance of hyperprior distribution of m0
#' @param tau1 shape parameter of hyperprior distribution of k0
#' @param tau2 rate parameter of hyperprior distribution of k0
#' @param theta1 df of hyperprior distribution of S0
#' @param Theta1 matrix of hyperprior distribution of S0
#' @param strength strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name cICS_mv_P
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via importance conditional sampler - PRODUCT KERNEL
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 vector, scale parameters for the location component
#' @param a0 vector, parameters of scale component
#' @param b0 vector, parameters of scale component
#' @param m1 means of hyperdistribution of m0
#' @param s21 variances of hyperdistribution of m0
#' @param tau1 shape parameters of hyperdistribution of k0
#' @param tau2 rate parameters of hyperdistribution of k0
#' @param a1 shape parameters of hyperdistribution of b0
#' @param b1 rate parameters of hyperdistribution of b0
#' @param strength strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name cICS_mv_MKR
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via importance conditional sampler - PRODUCT KERNEL
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 vector, scale parameters for the location component
#' @param a0 vector, parameters of scale component
#' @param b0 vector, parameters of scale component
#' @param m1 means of hyperdistribution of m0
#' @param s21 variances of hyperdistribution of m0
#' @param tau1 shape parameters of hyperdistribution of k0
#' @param tau2 rate parameters of hyperdistribution of k0
#' @param a1 shape parameters of hyperdistribution of b0
#' @param b1 rate parameters of hyperdistribution of b0
#' @param strength strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

cICS_L <- function(data, grid, niter, nburn, m0, s20, a0, b0, m1, k1, a1, b1, strength, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, hyper = 1L) {
    .Call('_BNPmix_cICS_L', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, s20, a0, b0, m1, k1, a1, b1, strength, napprox, nupd, out_param, out_dens, discount, print_message, hyper)
}

cICS <- function(data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, strength, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, hyper = 1L) {
    .Call('_BNPmix_cICS', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, strength, napprox, nupd, out_param, out_dens, discount, print_message, hyper)
}

cICS_mv_L <- function(data, grid, niter, nburn, m0, S20, S0, n0, m1, k1, theta1, Theta1, strength, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_cICS_mv_L', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, S20, S0, n0, m1, k1, theta1, Theta1, strength, napprox, nupd, out_param, out_dens, discount, print_message, light_dens, hyper)
}

cICS_mv <- function(data, grid, niter, nburn, m0, k0, S0, n0, m1, S1, tau1, tau2, theta1, Theta1, strength, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_cICS_mv', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, S0, n0, m1, S1, tau1, tau2, theta1, Theta1, strength, napprox, nupd, out_param, out_dens, discount, print_message, light_dens, hyper)
}

cICS_mv_P <- function(data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, strength, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_cICS_mv_P', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, strength, napprox, nupd, out_param, out_dens, discount, print_message, light_dens, hyper)
}

cICS_mv_MKR <- function(y, covs, grid_response, grid_covs, niter, nburn, beta0, Sb0, a0, b0, beta1, k1, sb1, Sb1, tau1, tau2, strength, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, light_dens = 1L, hyper = 1L) {
    .Call('_BNPmix_cICS_mv_MKR', PACKAGE = 'BNPmix', y, covs, grid_response, grid_covs, niter, nburn, beta0, Sb0, a0, b0, beta1, k1, sb1, Sb1, tau1, tau2, strength, napprox, nupd, out_param, out_dens, discount, print_message, light_dens, hyper)
}

#' @export
#' @name cSLI_L
#' @title C++ function to estimate Pitman-Yor univariate mixtures via slice sampler - LOCATION
#' @keywords internal
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param s20 variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param m1 hyperparameter, mean of distribution of m0
#' @param k1 hyperparameter, scale factor of distribution of m0
#' @param a1 hyperparameter, shape of distribution of s20
#' @param b1 hyperparameter, rate of distribution of s20
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

#' @export
#' @name cSLI
#' @title C++ function to estimate Pitman-Yor univariate mixtures via slice sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param m1 mean of hyperdistribution of m0
#' @param s21 variance of hyperdistribution of m0
#' @param tau1 shape parameter of hyperdistribution of k0
#' @param tau2 rate parameter of hyperdistribution of k0
#' @param a1 shape parameter of hyperdistribution of b0
#' @param b1 rate parameter of hyperdistribution of b0
#' @param mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param hyper, if TRUE use hyperpriors, default TRUE
#' @param indep, if TRUE use the independent slice efficient
NULL

#' @export
#' @name cSLI_mv_L
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via slice sampler - LOCATION
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param S20 variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param m1 mean of hyperdistribtion of m0
#' @param k1 scale factor of hyperdistribtion of m0
#' @param theta1 df of hyperdistribtion of S20
#' @param Theta1 matrix of hyperdistribution of S20
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
#' @param indep if TRUE use independent slice efficient
NULL

#' @export
#' @name cSLI_mv
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via slice sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param m1 mean of hyperprior distribution of m0
#' @param S1 covariance of hyperprior distribution of m0
#' @param tau1 shape parameter of hyperprior distribution of k0
#' @param tau2 rate parameter of hyperprior distribution of k0
#' @param theta1 df of hyperprior distribution of S0
#' @param Theta1 matrix of hyperprior distribution of S0
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
#' @param indep if TRUE use the independent slice efficient
NULL

#' @export
#' @name cSLI_mv_P
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via slice sampler - LOCATION SCALE
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param m1 means of hyperdistribution of m0
#' @param s21 variances of hyperdistribution of m0
#' @param tau1 shape parameters of hyperdistribution of k0
#' @param tau2 rate parameters of hyperdistribution of k0
#' @param a1 shape parameters of hyperdistribution of b0
#' @param b1 rate parameters of hyperdistribution of b0
#' @param mass mass parameter
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
#' @param indep if TRUE use the independent slice efficient
NULL

#' @export
#' @name cSLI_mv_MKR
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via slice sampler - PRODUCT KERNEL
#' @keywords internal
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 vector, scale parameters for the location component
#' @param a0 vector, parameters of scale component
#' @param b0 vector, parameters of scale component
#' @param m1 means of hyperdistribution of m0
#' @param s21 variances of hyperdistribution of m0
#' @param tau1 shape parameters of hyperdistribution of k0
#' @param tau2 rate parameters of hyperdistribution of k0
#' @param a1 shape parameters of hyperdistribution of b0
#' @param b1 rate parameters of hyperdistribution of b0
#' @param strength strength parameter
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param discount second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#' @param hyper, if TRUE use hyperpriors, default TRUE
NULL

cSLI_L <- function(data, grid, niter, nburn, m0, s20, a0, b0, m1, k1, a1, b1, mass, param_seq_one, param_seq_two, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, hyper = TRUE, indep = FALSE) {
    .Call('_BNPmix_cSLI_L', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, s20, a0, b0, m1, k1, a1, b1, mass, param_seq_one, param_seq_two, nupd, out_param, out_dens, sigma_PY, print_message, hyper, indep)
}

cSLI <- function(data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, param_seq_one, param_seq_two, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, hyper = 1L, indep = TRUE) {
    .Call('_BNPmix_cSLI', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, param_seq_one, param_seq_two, nupd, out_param, out_dens, sigma_PY, print_message, hyper, indep)
}

cSLI_mv_L <- function(data, grid, niter, nburn, m0, S20, S0, n0, m1, k1, theta1, Theta1, mass, param_seq_one, param_seq_two, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L, hyper = 1L, indep = TRUE) {
    .Call('_BNPmix_cSLI_mv_L', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, S20, S0, n0, m1, k1, theta1, Theta1, mass, param_seq_one, param_seq_two, nupd, out_param, out_dens, sigma_PY, print_message, light_dens, hyper, indep)
}

cSLI_mv <- function(data, grid, niter, nburn, m0, k0, S0, n0, m1, S1, tau1, tau2, theta1, Theta1, mass, param_seq_one, param_seq_two, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L, hyper = 1L, indep = TRUE) {
    .Call('_BNPmix_cSLI_mv', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, S0, n0, m1, S1, tau1, tau2, theta1, Theta1, mass, param_seq_one, param_seq_two, nupd, out_param, out_dens, sigma_PY, print_message, light_dens, hyper, indep)
}

cSLI_mv_P <- function(data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, param_seq_one, param_seq_two, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L, hyper = 1L, indep = TRUE) {
    .Call('_BNPmix_cSLI_mv_P', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, m1, s21, tau1, tau2, a1, b1, mass, param_seq_one, param_seq_two, nupd, out_param, out_dens, sigma_PY, print_message, light_dens, hyper, indep)
}

cSLI_mv_MKR <- function(y, covs, grid_response, grid_covs, niter, nburn, beta0, Sb0, a0, b0, beta1, k1, sb1, Sb1, tau1, tau2, strength, param_seq_one, param_seq_two, nupd = 0L, out_param = 0L, out_dens = 1L, discount = 0, print_message = 1L, light_dens = 1L, hyper = 1L, indep = TRUE) {
    .Call('_BNPmix_cSLI_mv_MKR', PACKAGE = 'BNPmix', y, covs, grid_response, grid_covs, niter, nburn, beta0, Sb0, a0, b0, beta1, k1, sb1, Sb1, tau1, tau2, strength, param_seq_one, param_seq_two, nupd, out_param, out_dens, discount, print_message, light_dens, hyper, indep)
}

#' @export BNPmix_psm
#' @name BNPmix_psm
#' @title C++ function - compute the posterior similarity matrix
#' @keywords internal
#'
#' @param M a matrix (r x n), r number of replications, n number of observations
#'
#' @examples{
#'   M <- matrix(c(1,1,1,2,1,1,2,2,1,1,2,1,1,2,1,1), ncol = 4)
#'   BNPmix_psm(M)
#' }
#'
NULL

#' @export clean_partition
#' @name clean_partition
#' @title C++ function - clean the partition matrix
#' @keywords internal
#'
#' @param M a matrix (r x n), r number of replications, n number of observations
#'
#' @examples{
#'   M <- matrix(c(1,1,1,3,1,1,4,4,1,1,3,1,1,3,1,1), ncol = 4)
#'   clean_partition(M)
#' }
#'
NULL

#' @export BNPmix_VI_LB
#' @name BNPmix_VI_LB
#' @title C++ function - compute the VI lower bound
#' @keywords internal
#'
#' @param M a matrix (r x n), r number of replications, n number of observations
#' @param psm_mat a posterior similarity matrix
#'
#' @examples{
#'   M <- matrix(c(1,1,1,2,1,1,2,2,1,1,2,1,1,1,1,2), ncol = 4)
#'   psmM <- BNPmix_psm(M)
#'   BNPmix_VI_LB(M, psmM)
#' }
#'
NULL

#' @export BNPmix_BIN
#' @name BNPmix_BIN
#' @title C++ function - compute the Binder distances
#' @keywords internal
#'
#' @param M a matrix (r x n), r number of replications, n number of observations
#' @param psm_mat a posterior similarity matrix
#'
#' @examples{
#'   M <- matrix(c(1,1,1,2,1,1,2,2,1,1,2,1,1,1,1,2), ncol = 4)
#'   psmM <- BNPmix_psm(M)
#'   BNPmix_BIN(M, psmM)
#' }
#'
NULL

BNPmix_psm <- function(M) {
    .Call('_BNPmix_BNPmix_psm', PACKAGE = 'BNPmix', M)
}

clean_partition <- function(M) {
    .Call('_BNPmix_clean_partition', PACKAGE = 'BNPmix', M)
}

BNPmix_VI_LB <- function(C_mat, psm_mat) {
    .Call('_BNPmix_BNPmix_VI_LB', PACKAGE = 'BNPmix', C_mat, psm_mat)
}

BNPmix_BIN <- function(C_mat, psm_mat) {
    .Call('_BNPmix_BNPmix_BIN', PACKAGE = 'BNPmix', C_mat, psm_mat)
}

