\name{gprior-class}
\docType{class}
\alias{gprior-class}

\title{Class "gprior"}
\description{ An object pertaining to a coefficient prior}
\section{Objects from the Class}{
A \code{gprior} object holds descriptions and subfunctions pertaining to coefficent priors. Functions such as \code{\link{bms}} or \code{\link{zlm}}
rely on this class to 'convert' the output of OLS results into posterior expressions for a Bayesian Linear Model. Post-processing functions such as \code{\link{density.bma}} also resort to gprior objects.\cr
There are currently three coefficient prior structures built into the BMS package, generated by the following functions (cf. Feldkircher and Zeugner, 2009) : \cr
\code{gprior.constg.init}: creates a Zellner's g-prior object with constant \code{g}.\cr
\code{gprior.eblocal.init}: creates an Empricial Bayes Zellner's g-prior.\cr
\code{gprior.hyperg.init}: creates a hyper g-prior with a Beta-prior on the shrinakge parameter.\cr
The following describes the necessary slots 
}
\section{Slots}{
  \describe{
    \item{\code{gtype}:}{A string  with a human-readable identifier of the prior.}
    \item{\code{is.constant}:}{ Boolean whether the gprior relies on a constant scalar \code{g} (that is not dependent on a model) }
    \item{\code{return.g.stats}:}{Boolean for whether to collect posterior statistics on shrinkage.}
    \item{\code{g}:}{Shold hold the value of \code{g} when \code{is.constant==TRUE}.}
    \item{\code{lprobcalc}:}{A list with a least two sub-functions:
        \describe{
        \item{\code{just.loglik(ymy, k, ...)}:}{returns scalar posterior log-likelihood based on residual sum of squares \code{ymy} and number of parameters \code{k} }
        \item{\code{lprob.all(ymy, k, bhat, diag.inverse, ...)}:}{ Takes output from an OLS model (\code{bhat}: OLS coefficients, \code{diag.inverse}: diagonal of the matrix \code{inv(t(X)*X)}), and returns a list with log-likelihood and posterior moments. } 
        }
    }
    
  }
}
\section{Methods}{
As for now, there are no methods defined with class "gprior" in the signature.
}
\references{ 
Feldkircher, M. and S. Zeugner (2009): Benchmark Priors Revisited: On Adaptive Shrinkage and the Supermodel Effect in Bayesian Model Averaging, IMF Working Paper 09/202.
}
\author{Martin Feldkircher and Stefan Zeugner}
\seealso{
	 \code{\link{bms}} and \code{\link{zlm}} for creating \code{bma} or \code{zlm} objects. \cr
     Check the appendix of \code{vignette(BMS)} for a more detailed description of built-in priors.\cr
     Check \url{http://bms.zeugner.eu/custompriors.php} for examples.
}
\examples{

data(datafls)
mm1=bms(datafls[,1:10], g="EBL")
gg=mm1$gprior.info # is the g-prior object, augmented with some posterior statistics

mm2=bms(datafls[,1:10], g=gg) #produces the same result

mm3=bms(datafls[,1:10], g=BMS:::.gprior.eblocal.init) #this passes BMS's internal Empirical Bayes g-prior object as the coefficient prior - any other obejct might be used as well


}
\keyword{classes}
