% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elasticities.R
\name{get_elasticities}
\alias{get_elasticities}
\title{Calculates elasticities for a given variable and market.}
\usage{
get_elasticities(blp_data, share_info, theta_lin, variable, products,
  market, printLevel = 1)
}
\arguments{
\item{blp_data}{data object created by the function \code{BLP_data},}

\item{share_info}{object with individual and aggregated choice probabilities created by the function \code{getShareInfo},}

\item{theta_lin}{linear parameter of the variable for which elasticities are calculated for,}

\item{variable}{character specifying a variable for which elasticities are calculated for,}

\item{products}{optional: character vector of specific products,}

\item{market}{character specifying the market in which elasticities are calculated}

\item{printLevel}{level of output information (default = 1)}
}
\value{
Returns a matrix with elasticities. Value in row j and col i for a variable x,
gives the effect of a change in product i's characteristic x on the share of product j.
}
\description{
Calculates elasticities for a given variable and market.
}
\examples{
K<-2 #number of random coefficients
data <- simulate_BLP_dataset(nmkt = 25, nbrn = 20,
                             Xlin = c("price", "x1", "x2", "x3", "x4", "x5"),
                             Xexo = c("x1", "x2", "x3", "x4", "x5"),
                             Xrandom = paste0("x",1:K),instruments = paste0("iv",1:10),
                             true.parameters = list(Xlin.true.except.price = rep(0.2,5),
                                                    Xlin.true.price = -0.2,
                                                    Xrandom.true = rep(2,K),
                                                    instrument.effects = rep(2,10),
                                                    instrument.Xexo.effects = rep(1,5)),
                             price.endogeneity = list( mean.xi = -2,
                                                       mean.eita = 0,
                                                       cov = cbind( c(1,0.7), c(0.7,1))),
                             printlevel = 0, seed = 234234 )


model <- as.formula("shares ~  price + x1 + x2 + x3 + x4 + x5 |
                    x1 + x2 + x3 + x4 + x5 |
                    0+ x1 + x2 |
                    iv1 + iv2 + iv3 + iv4 + iv5 + iv6 + iv7 + iv8 +iv9 +iv10" )

blp_data <- BLP_data(model = model, market_identifier="cdid",
                     product_id = "prod_id",
                     productData = data,
                     integration_method = "MLHS" ,
                     integration_accuracy = 40,
                     integration_seed = 1)

theta_guesses <- matrix(c(0.5,2), nrow=2)
rownames(theta_guesses) <- c("x1","x2")
colnames(theta_guesses) <- "unobs_sd"

shareObj <- getShareInfo(  blp_data=blp_data,
                           par_theta2 = theta_guesses,
                           printLevel = 1)


get_elasticities(blp_data=blp_data,
                 share_info = shareObj ,
                 theta_lin = 1,
                 variable = "price",
                 products = c("4","20"),
                 market = 1)

}
