% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlayBirds.R
\name{overlayBirds}
\alias{overlayBirds}
\alias{overlayBirds.OrganizedBirds}
\title{Overlay BIRDS object and grid}
\usage{
overlayBirds(x, grid, spillOver = NULL, cleanGrid = TRUE)

\method{overlayBirds}{OrganizedBirds}(x, grid, spillOver = NULL, cleanGrid = TRUE)
}
\arguments{
\item{x}{An OrganizedBirds object}

\item{grid}{A sf or SpatialPolygonsDataFrame object of the grid over the study area}

\item{spillOver}{Specifies if the function should search for observations
with the same visitUID over several grid cell, and what to do with them.
It accepts \code{c(NULL, "unique", "duplicate")}. Default NULL.}

\item{cleanGrid}{logical. Whether to remove all data from the grid.}
}
\value{
The output is a OverlaidBirds-class object, which is a list
  containing three objects;
  \describe{
    \item{\code{observationsInGrid}}{Is
      basically the data in the OrganizedBirds object split by each grid cell
      (\emph{n.b.} the use of \code{spillOver} discussed under "Usage")}
    \item{\code{grid}}{The sf from the input, optionally cleared of data }
   \item{\code{nonEmptyGridCells}}{An integer vector of which grid cells that have observations}
  }
}
\description{
Make an overlay for an OrganizedBirds object and a grid to identify which
observations that fall into which grid cell.
}
\details{
This function takes an OrganizedBirds object, created by
\code{\link{organizeBirds}}, and a polygon grid-layer, which could be created
by \code{\link{makeGrid}} and splits the visits in the OrganizedBirds
(i.e. data belonging to identified visits) to each grid cell.

If \code{spillOver = NULL} the splitting is done spatially according to the
overlay of observations and grid cells, without further consideration of
coherence for visits (visit UID). If \code{spillOver = c("unique", "duplicate")}
the splitting will be done spatially in a first step, and then:
if \code{(spillOver = "unique")} assigns (and moves) all observations with same visitUID
to the grid cell with most observations (or picks one grid cell at random if
there is a tie); or if \code{(spillOver = "duplicate")} duplicates all
observations with same visitUID across all grid cells containing at least one
observation with that visitUID.

The later approach is useful when the amount of observations spilled over
neighbouring cells is minimal and information over the spatial extent of the
sampling effort is more important than sample independence.
}
\examples{
\donttest{
ob <- organizeBirds(bombusObs)
grid <- makeGrid(gotaland, 10)
ovB <- overlayBirds(ob, grid) 
}
}
