% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madc2vcf_targets.R
\name{madc2vcf_targets}
\alias{madc2vcf_targets}
\title{Format MADC Target Loci Read Counts Into VCF}
\usage{
madc2vcf_targets(madc_file, output.file, botloci_file, get_REF_ALT = FALSE)
}
\arguments{
\item{madc_file}{Path to MADC file}

\item{output.file}{output file name and path}

\item{botloci_file}{A string specifying the path to the file containing the target IDs designed in the bottom strand.}

\item{get_REF_ALT}{if TRUE recovers the reference and alternative bases by comparing the sequences. If more than one polymorphism are found for a tag, it is discarded.}
}
\value{
A VCF file v4.3 with the target marker read count information

A VCF file v4.3 with the target marker read count information
}
\description{
This function will extract the read count information from a MADC file target markers and convert to VCF file format.
}
\details{
The DArTag MADC file format is not commonly supported through existing tools. This function
will extract the read count information from a MADC file for the target markers and convert it to a VCF file format for the
genotyping panel target markers only
}
\examples{
# Load example files
madc_file <- system.file("example_MADC_FixedAlleleID.csv", package="BIGr")
bot_file <- system.file("example_SNPs_DArTag-probe-design_f180bp.botloci", package="BIGr")

#Temp location (only for example)
output_file <- tempfile()

# Convert MADC to VCF
madc2vcf_targets(madc_file = madc_file,
                 output.file = output_file,
                 get_REF_ALT = TRUE,
                 botloci_file = bot_file)

rm(output_file)

}
