% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{maxR}
\alias{maxR}
\title{Compute maxR statistic for each off-axis dose combination}
\usage{
maxR(
  data,
  fitResult,
  transforms = fitResult$transforms,
  null_model = c("loewe", "hsa", "bliss", "loewe2"),
  Ymean,
  CP,
  reps,
  nested_bootstrap = FALSE,
  B.B = NULL,
  B.CP = NULL,
  cutoff = 0.95,
  cl = NULL,
  method = c("equal", "model", "unequal"),
  ...
)
}
\arguments{
\item{data}{Dose-response dataframe.}

\item{fitResult}{Monotherapy (on-axis) model fit, e.g. produced by
\code{\link{fitMarginals}}. It has to be a \code{"MarginalFit"} object or a
list containing \code{df}, \code{sigma}, \code{coef},
\code{shared_asymptote} and \code{method} elements for, respectively,
marginal model degrees of freedom, residual standard deviation, named
vector of coefficient estimates, logical value of whether shared asymptote
is imposed and method for estimating marginal models during bootstrapping
(see \code{\link{fitMarginals}}). If biological and power transformations
were used in marginal model estimation, \code{fitResult} should contain
\code{transforms} elements with these transformations. Alternatively, these
can also be specified via \code{transforms} argument.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{null_model}{Specified null model for the expected response surface.
Currently, allowed options are \code{"loewe"} for generalized Loewe model,
\code{"hsa"} for Highest Single Agent model, \code{"bliss"} for Bliss additivity,
and \code{"loewe2"} for the alternative Loewe generalization.}

\item{Ymean}{Aggregate summary of off-axis predicted responses. In
particular, it should contain \code{"effect - predicted"} column. If
\code{Ymean} is missing, it will be calculated automatically from output of
\code{\link{predictOffAxis}} function.}

\item{CP}{Prediction covariance matrix. If not specified, it will be estimated
by bootstrap using \code{B.CP} iterations.}

\item{reps}{Numeric vector containing number of replicates for each off-axis
dose combination. If missing, it will be calculated automatically from output
of \code{\link{predictOffAxis}} function.}

\item{nested_bootstrap}{When statistics are calculated, if
\code{nested_bootstrap = TRUE}, \code{CP} matrix is recalculated at each
bootstrap iteration of \code{B.B} using \code{B.CP} iterations. Using such
nested bootstrap may however significantly increase computational time. If
\code{nested_bootstrap = FALSE}, \code{CP} bootstrapped data reuses
\code{CP} matrix calculated from the original data.}

\item{B.B}{Number of iterations to use in bootstrapping null distribution for
either meanR or maxR statistics.}

\item{B.CP}{Number of bootstrap iterations to use for CP matrix estimation}

\item{cutoff}{Cut-off to use in maxR procedure for declaring non-additivity
(default is 0.95).}

\item{cl}{If parallel computations are desired, \code{cl} should be a cluster
object created by \code{\link[parallel]{makeCluster}}. If parallel
computing is active, progress reporting messages are not necessarily
ordered as it should be expected.}

\item{method}{What assumption should be used for the variance of on- and 
off-axis points. This argument can take one of the values from 
\code{c("equal", "model", "unequal")}. With the value \code{"equal"} as the
default. \code{"equal"} assumes that both on- and off-axis points have the 
same variance, \code{"unequal"} estimates a different parameter for on- and 
off-axis points and \code{"model"} predicts variance based on the average 
effect of an off-axis point. If no transformations are used the 
\code{"model"} method is recommended. If transformations are used, only the
\code{"equal"} method can be chosen.}

\item{...}{Further arguments that will be later passed to
\code{\link{generateData}} function during bootstrapping}
}
\value{
This function returns a \code{maxR} object with estimates for the
  maxR statistical test. \code{maxR} object is essentially a list with
  appropriately named elements.

  In particular, \code{maxR} object contains \code{"Ymean"} element which is
  a summary table of maxR test results for each dose combination. This table
  contains mean deviation from the predicted surface, normalized deviation
  (\code{"absR"}) as well as a statistical call whether this deviation is
  significant. Distributional information on which these calls are made can
  be retrieved from the attributes of the \code{"Ymean"} dataframe.

  Also, \code{maxR} object contains \code{"Call"} element which indicates the
  general direction of the deviation of the observed surface from the null.
  This call is based on the strongest local deviation in the \code{"Ymean"}
  table. 4 values are available here: \code{"Syn"}, \code{"Ant"},
  \code{"None"}, \code{"Undefined"}. If one compound acts as an agonist while
  another one is an antagonist, then a deviation from the null is classified
  as \code{"Undefined"}. If both compounds act in the same direction, then a
  stronger than individual effect is classified as synergy while a weaker
  effect would be classified as antagonism.
}
\description{
\code{\link{maxR}} computes maxR statistics for each off-axis dose
combination given the data provided. It provides a summary with results
indicating whether a given point is estimated to be synergetic or
antagonistic. These can be based either on normal approximation or a
fully bootstrapped distribution of the statistics.
}
\examples{
  data <- subset(directAntivirals, experiment == 2)
  ## Data must contain d1, d2 and effect columns
  fitResult <- fitMarginals(data)
  CP <- CPBootstrap(data, fitResult, null_model = "loewe", B.CP = 5)
  maxR(data, fitResult, null_model = "loewe", CP = CP)
}
