% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_stem_species}
\alias{BIEN_stem_species}
\title{Extract stem data for specified species from BIEN}
\usage{
BIEN_stem_species(
  species,
  cultivated = FALSE,
  new.world = NULL,
  all.taxonomy = FALSE,
  native.status = FALSE,
  natives.only = TRUE,
  political.boundaries = FALSE,
  collection.info = FALSE,
  all.metadata = FALSE,
  ...
)
}
\arguments{
\item{species}{A single species, or a vector of species.  Genus and species should be separated by a space. Genus should be capitalized.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{new.world}{NULL (The default) returns global records, TRUE returns only New World, and FALSE only Old World.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{all.metadata}{Should additional plot metadata be returned?  Default is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing stem data for the specified species.
}
\description{
BIEN_stem_species downloads occurrence records for specific species from the BIEN database.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php

Setting either "cultivated" or "native.status" to TRUE will significantly slow the speed of a query.
}
\examples{
\dontrun{
BIEN_stem_species("Abies amabilis")
species_vector<-c("Abies amabilis", "Acer nigrum")
BIEN_stem_species(species_vector)
BIEN_stem_species(species_vector,all.taxonomy = TRUE)}
}
\seealso{
Other stem functions: 
\code{\link{BIEN_stem_datasource}()},
\code{\link{BIEN_stem_family}()},
\code{\link{BIEN_stem_genus}()},
\code{\link{BIEN_stem_sampling_protocol}()}
}
\concept{stem functions}
