% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_shapefile}
\alias{BIEN_ranges_shapefile}
\title{Download range maps that intersect a user-supplied shapefile.}
\usage{
BIEN_ranges_shapefile(shapefile, directory = NULL,
  species_names_only = FALSE, return.species.list = TRUE,
  crop.ranges = FALSE, include.gid = FALSE, ...)
}
\arguments{
\item{shapefile}{An object of class SpatialPolygonsDataFrame.}

\item{directory}{Directory that range maps should be saved in.  If none is specified, range maps will be saved in the current working directory.}

\item{species_names_only}{Get a list of the species with ranges overlapping the focal species' range without downloading range maps. Default is FALSE.}

\item{return.species.list}{Should a species list be returned?  Only meaningful when maps are being downloaded.}

\item{crop.ranges}{Should the returned shapefiles be cropped to the supplied shapefile?}

\item{include.gid}{Should the filenames returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species. Default is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
All range maps that intersect the user-supplied shapfile.
}
\description{
BIEN_ranges_shapefile extracts range maps that interesect a specified shapefile.
}
\note{
We recommend using the function readOGR() in the rgdal package to read in shapefiles.  Other methods may cause problems related to handling holes in polygons.
}
\examples{
\dontrun{
BIEN_ranges_species("Carnegiea gigantea")#saves ranges to the current working directory
shape<-readOGR(dsn = ".",layer = "Carnegiea_gigantea")
#shapefiles should be read with readOGR(), see note.
BIEN_ranges_shapefile(shapefile = shape) 
#Note that this will save many shapefiles to the working directory.
}
}
\seealso{
Other range functions: \code{\link{BIEN_ranges_box}},
  \code{\link{BIEN_ranges_genus}},
  \code{\link{BIEN_ranges_intersect_species}},
  \code{\link{BIEN_ranges_list}},
  \code{\link{BIEN_ranges_load_species}},
  \code{\link{BIEN_ranges_species}}
}
