% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_traitbyspecies}
\alias{BIEN_trait_traitbyspecies}
\title{Download trait data for given species and trait.}
\usage{
BIEN_trait_traitbyspecies(trait, species, print.query = FALSE, ...)
}
\arguments{
\item{trait}{A single trait or a vector of traits.}

\item{species}{A single species or a vector of species.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
A dataframe of all data matching the specified trait(s) and species.
}
\description{
BIEN_trait_traitbyspecies extracts entries that contain the specified species and trait(s).
}
\examples{
\dontrun{
BIEN_trait_traitbyspecies(trait = "Height", species = "Carex capitata")
trait_vector<-c("Height", "Leaf dry mass")
species_vector<-c("Carex capitata","Betula nana")
BIEN_trait_traitbyspecies(trait=trait_vector,species=species_vector)}
}
\seealso{
Other trait functions: \code{\link{BIEN_trait_family}},
  \code{\link{BIEN_trait_list}},
  \code{\link{BIEN_trait_mean}},
  \code{\link{BIEN_trait_species}},
  \code{\link{BIEN_trait_traitbyfamily}},
  \code{\link{BIEN_trait_traitbygenus}},
  \code{\link{BIEN_trait_traits_per_species}},
  \code{\link{BIEN_trait_trait}}
}

